<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLdapDirectory StructType
 * @subpackage Structs
 */
class RLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public $servers;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The mailId
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailId;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The managerId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $managerId;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $department;
    /**
     * The ldapFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ldapFilter;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUri;
    /**
     * The accessControlGroupInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The featureGroupTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureGroupTemplate;
    /**
     * The applyMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyMask;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mask;
    /**
     * The applyPoolList
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyPoolList;
    /**
     * The addDns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddDns
     */
    public $addDns;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLdapDirectory
     * @uses RLdapDirectory::setName()
     * @uses RLdapDirectory::setLdapDn()
     * @uses RLdapDirectory::setLdapPassword()
     * @uses RLdapDirectory::setUserSearchBase()
     * @uses RLdapDirectory::setRepeatable()
     * @uses RLdapDirectory::setIntervalValue()
     * @uses RLdapDirectory::setScheduleUnit()
     * @uses RLdapDirectory::setNextExecTime()
     * @uses RLdapDirectory::setServers()
     * @uses RLdapDirectory::setMiddleName()
     * @uses RLdapDirectory::setPhoneNumber()
     * @uses RLdapDirectory::setMailId()
     * @uses RLdapDirectory::setUserId()
     * @uses RLdapDirectory::setManagerId()
     * @uses RLdapDirectory::setFirstName()
     * @uses RLdapDirectory::setLastName()
     * @uses RLdapDirectory::setDepartment()
     * @uses RLdapDirectory::setLdapFilter()
     * @uses RLdapDirectory::setDirectoryUri()
     * @uses RLdapDirectory::setAccessControlGroupInfo()
     * @uses RLdapDirectory::setFeatureGroupTemplate()
     * @uses RLdapDirectory::setApplyMask()
     * @uses RLdapDirectory::setMask()
     * @uses RLdapDirectory::setApplyPoolList()
     * @uses RLdapDirectory::setAddDns()
     * @uses RLdapDirectory::setUuid()
     * @param string $name
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @param string $middleName
     * @param string $phoneNumber
     * @param string $mailId
     * @param string $userId
     * @param string $managerId
     * @param string $firstName
     * @param string $lastName
     * @param string $department
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter
     * @param string $directoryUri
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate
     * @param string $applyMask
     * @param string $mask
     * @param string $applyPoolList
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns
     * @param string $uuid
     */
    public function __construct($name = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = null, $nextExecTime = null, \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null, $middleName = null, $phoneNumber = null, $mailId = null, $userId = null, $managerId = null, $firstName = null, $lastName = null, $department = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter = null, $directoryUri = null, \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate = null, $applyMask = null, $mask = null, $applyPoolList = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setMiddleName($middleName)
            ->setPhoneNumber($phoneNumber)
            ->setMailId($mailId)
            ->setUserId($userId)
            ->setManagerId($managerId)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setDepartment($department)
            ->setLdapFilter($ldapFilter)
            ->setDirectoryUri($directoryUri)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setFeatureGroupTemplate($featureGroupTemplate)
            ->setApplyMask($applyMask)
            ->setMask($mask)
            ->setApplyPoolList($applyPoolList)
            ->setAddDns($addDns)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string|null
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setLdapPassword($ldapPassword = null)
    {
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string|null
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @param string $intervalValue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @param string $scheduleUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = null)
    {
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Servers|null
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setServers(\\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setMiddleName($middleName = null)
    {
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get mailId value
     * @return string|null
     */
    public function getMailId()
    {
        return $this->mailId;
    }
    /**
     * Set mailId value
     * @param string $mailId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setMailId($mailId = null)
    {
        $this->mailId = $mailId;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setUserId($userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get managerId value
     * @return string|null
     */
    public function getManagerId()
    {
        return $this->managerId;
    }
    /**
     * Set managerId value
     * @param string $managerId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setManagerId($managerId = null)
    {
        $this->managerId = $managerId;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setFirstName($firstName = null)
    {
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setLastName($lastName = null)
    {
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setDepartment($department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get ldapFilter value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLdapFilter()
    {
        return $this->ldapFilter;
    }
    /**
     * Set ldapFilter value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setLdapFilter(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter = null)
    {
        $this->ldapFilter = $ldapFilter;
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setDirectoryUri($directoryUri = null)
    {
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setAccessControlGroupInfo(\\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get featureGroupTemplate value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureGroupTemplate()
    {
        return $this->featureGroupTemplate;
    }
    /**
     * Set featureGroupTemplate value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setFeatureGroupTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate = null)
    {
        $this->featureGroupTemplate = $featureGroupTemplate;
        return $this;
    }
    /**
     * Get applyMask value
     * @return string|null
     */
    public function getApplyMask()
    {
        return $this->applyMask;
    }
    /**
     * Set applyMask value
     * @param string $applyMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setApplyMask($applyMask = null)
    {
        $this->applyMask = $applyMask;
        return $this;
    }
    /**
     * Get mask value
     * @return string|null
     */
    public function getMask()
    {
        return $this->mask;
    }
    /**
     * Set mask value
     * @param string $mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setMask($mask = null)
    {
        $this->mask = $mask;
        return $this;
    }
    /**
     * Get applyPoolList value
     * @return string|null
     */
    public function getApplyPoolList()
    {
        return $this->applyPoolList;
    }
    /**
     * Set applyPoolList value
     * @param string $applyPoolList
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setApplyPoolList($applyPoolList = null)
    {
        $this->applyPoolList = $applyPoolList;
        return $this;
    }
    /**
     * Get addDns value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddDns|null
     */
    public function getAddDns()
    {
        return $this->addDns;
    }
    /**
     * Set addDns value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setAddDns(\\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns = null)
    {
        $this->addDns = $addDns;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RLdapDirectory
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
