<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeServer StructType
 * @subpackage Structs
 */
class RImeServer extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Value shpuld be between 1024 and 65535
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $applicationUser;
    /**
     * The reconnectInterval
     * Meta information extracted from the WSDL
     * - documentation: Value should be between 60 and 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reconnectInterval;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeServer
     * @uses RImeServer::setName()
     * @uses RImeServer::setDescription()
     * @uses RImeServer::setIpAddress()
     * @uses RImeServer::setPort()
     * @uses RImeServer::setDeviceSecurityMode()
     * @uses RImeServer::setApplicationUser()
     * @uses RImeServer::setReconnectInterval()
     * @uses RImeServer::setUuid()
     * @param string $name
     * @param string $description
     * @param string $ipAddress
     * @param string $port
     * @param string $deviceSecurityMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @param string $reconnectInterval
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $ipAddress = null, $port = null, $deviceSecurityMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null, $reconnectInterval = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setApplicationUser($applicationUser)
            ->setReconnectInterval($reconnectInterval)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setPort($port = null)
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @param string $deviceSecurityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setApplicationUser(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @param string $reconnectInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setReconnectInterval($reconnectInterval = null)
    {
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RImeServer
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
