<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCiscoCatalyst6000T1VoIPGatewayPri StructType
 * @subpackage Structs
 */
class RCiscoCatalyst6000T1VoIPGatewayPri extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The mlppPreemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppPreemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The calledPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPri;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPri;
    /**
     * The chanIe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $chanIe;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clockReference;
    /**
     * The dChannelEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The displayIE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIE;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pcmType;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csuParam;
    /**
     * The firstDelay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstDelay;
    /**
     * The interfaceIdPresent
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $interfaceIdPresent;
    /**
     * The interfaceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $interfaceId;
    /**
     * The intraDelay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intraDelay;
    /**
     * The mcdnEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mcdnEnable;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The passingPrecedenceLevelThrough
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $passingPrecedenceLevelThrough;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The connectedLineIdPresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectedLineIdPresentation;
    /**
     * The priProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priProtocol;
    /**
     * The securityAccessLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $securityAccessLevel;
    /**
     * The sendCallingNameInFacilityIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendCallingNameInFacilityIe;
    /**
     * The sendExLeadingCharInDispIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendExLeadingCharInDispIe;
    /**
     * The sendRestart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The span
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $span;
    /**
     * The statusPoll
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The smdiBasePort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $smdiBasePort;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The v150
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $v150;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only if PRI variant is QSIG
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The QSIGVariant
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only PRI variant is QSIG
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QSIGVariant;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCiscoCatalyst6000T1VoIPGatewayPri
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setDescription()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setProduct()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setModel()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setClass()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setProtocol()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setProtocolSide()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCallingSearchSpaceName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setDevicePoolName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCommonDeviceConfigName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setNetworkLocation()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setLocationName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setNetworkLocale()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setMediaResourceListName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setAutomatedAlternateRoutingCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setAarNeighborhoodName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setLoadInformation()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setVendorConfig()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setMlppDomainId()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setMlppIndicationStatus()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setMlppPreemption()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseTrustedRelayPoint()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCgpnTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCss()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setGeoLocationName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setRedirectInboundNumberIe()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCalledPlan()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCalledPri()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCallerIdDn()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCallingPartySelection()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCallingPlan()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCallingPri()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setChanIe()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setClockReference()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setDChannelEnable()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setChannelSelectionOrder()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setDisplayIE()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPcmType()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCsuParam()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setFirstDelay()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setInterfaceIdPresent()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setInterfaceId()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setIntraDelay()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setMcdnEnable()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setRedirectOutboundNumberIe()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setNumDigitsToStrip()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPassingPrecedenceLevelThrough()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPrefix()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCallingLinePresentationBit()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setConnectedLineIdPresentation()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPriProtocol()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSecurityAccessLevel()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSendCallingNameInFacilityIe()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSendExLeadingCharInDispIe()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSendRestart()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSetupNonIsdnPi()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSigDigits()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSpan()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setStatusPoll()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSmdiBasePort()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPacketCaptureMode()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPacketCaptureDuration()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setTransmitUtf8()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setV150()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setAsn1RoseOidEncoding()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setQSIGVariant()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUnattendedPort()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setCdpnTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCdpnTransformCss()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setNationalPrefix()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setInternationalPrefix()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUnknownPrefix()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSubscriberPrefix()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setGeoLocationFilterName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setNationalStripDigits()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setInternationalStripDigits()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUnknownStripDigits()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSubscriberStripDigits()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setNationalTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setInternationalTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUnknownTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setSubscriberTransformationCssName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssNatl()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssIntl()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssSubs()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setPstnAccess()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setImeE164TransformationName()
     * @uses RCiscoCatalyst6000T1VoIPGatewayPri::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $mlppPreemption
     * @param string $useTrustedRelayPoint
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $redirectInboundNumberIe
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $chanIe
     * @param string $clockReference
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $displayIE
     * @param string $pcmType
     * @param string $csuParam
     * @param string $firstDelay
     * @param string $interfaceIdPresent
     * @param string $interfaceId
     * @param string $intraDelay
     * @param string $mcdnEnable
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $passingPrecedenceLevelThrough
     * @param string $prefix
     * @param string $callingLinePresentationBit
     * @param string $connectedLineIdPresentation
     * @param string $priProtocol
     * @param string $securityAccessLevel
     * @param string $sendCallingNameInFacilityIe
     * @param string $sendExLeadingCharInDispIe
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $span
     * @param string $statusPoll
     * @param string $smdiBasePort
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $transmitUtf8
     * @param string $v150
     * @param string $asn1RoseOidEncoding
     * @param string $qSIGVariant
     * @param string $unattendedPort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $pstnAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $mlppDomainId = null, $mlppIndicationStatus = null, $mlppPreemption = null, $useTrustedRelayPoint = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $redirectInboundNumberIe = null, $calledPlan = null, $calledPri = null, $callerIdDn = null, $callingPartySelection = null, $callingPlan = null, $callingPri = null, $chanIe = null, $clockReference = null, $dChannelEnable = null, $channelSelectionOrder = null, $displayIE = null, $pcmType = null, $csuParam = null, $firstDelay = null, $interfaceIdPresent = null, $interfaceId = null, $intraDelay = null, $mcdnEnable = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = null, $passingPrecedenceLevelThrough = null, $prefix = null, $callingLinePresentationBit = null, $connectedLineIdPresentation = null, $priProtocol = null, $securityAccessLevel = null, $sendCallingNameInFacilityIe = null, $sendExLeadingCharInDispIe = null, $sendRestart = null, $setupNonIsdnPi = null, \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $span = null, $statusPoll = null, $smdiBasePort = null, $packetCaptureMode = null, $packetCaptureDuration = null, $transmitUtf8 = null, $v150 = null, $asn1RoseOidEncoding = null, $qSIGVariant = null, $unattendedPort = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null, $useDevicePoolCgpnTransformCssNatl = null, $useDevicePoolCgpnTransformCssIntl = null, $useDevicePoolCgpnTransformCssUnkn = null, $useDevicePoolCgpnTransformCssSubs = null, $pstnAccess = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setNetworkLocale($networkLocale)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setMlppPreemption($mlppPreemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setChanIe($chanIe)
            ->setClockReference($clockReference)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setDisplayIE($displayIE)
            ->setPcmType($pcmType)
            ->setCsuParam($csuParam)
            ->setFirstDelay($firstDelay)
            ->setInterfaceIdPresent($interfaceIdPresent)
            ->setInterfaceId($interfaceId)
            ->setIntraDelay($intraDelay)
            ->setMcdnEnable($mcdnEnable)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPassingPrecedenceLevelThrough($passingPrecedenceLevelThrough)
            ->setPrefix($prefix)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setConnectedLineIdPresentation($connectedLineIdPresentation)
            ->setPriProtocol($priProtocol)
            ->setSecurityAccessLevel($securityAccessLevel)
            ->setSendCallingNameInFacilityIe($sendCallingNameInFacilityIe)
            ->setSendExLeadingCharInDispIe($sendExLeadingCharInDispIe)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setSpan($span)
            ->setStatusPoll($statusPoll)
            ->setSmdiBasePort($smdiBasePort)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setTransmitUtf8($transmitUtf8)
            ->setV150($v150)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQSIGVariant($qSIGVariant)
            ->setUnattendedPort($unattendedPort)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setModel($model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setProtocolSide($protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNetworkLocation($networkLocation = null)
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNetworkLocale($networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string|null
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @param string $mlppPreemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMlppPreemption($mlppPreemption = null)
    {
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string|null
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @param string $calledPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCalledPlan($calledPlan = null)
    {
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string|null
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @param string $calledPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCalledPri($calledPri = null)
    {
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string|null
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @param string $callingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingPlan($callingPlan = null)
    {
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string|null
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @param string $callingPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingPri($callingPri = null)
    {
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get chanIe value
     * @return string|null
     */
    public function getChanIe()
    {
        return $this->chanIe;
    }
    /**
     * Set chanIe value
     * @param string $chanIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setChanIe($chanIe = null)
    {
        $this->chanIe = $chanIe;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @param string $clockReference
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setClockReference($clockReference = null)
    {
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string|null
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string|null
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @param string $channelSelectionOrder
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setChannelSelectionOrder($channelSelectionOrder = null)
    {
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get displayIE value
     * @return string|null
     */
    public function getDisplayIE()
    {
        return $this->displayIE;
    }
    /**
     * Set displayIE value
     * @param string $displayIE
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDisplayIE($displayIE = null)
    {
        $this->displayIE = $displayIE;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @param string $pcmType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPcmType($pcmType = null)
    {
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @param string $csuParam
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCsuParam($csuParam = null)
    {
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string|null
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @param string $firstDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setFirstDelay($firstDelay = null)
    {
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get interfaceIdPresent value
     * @return string|null
     */
    public function getInterfaceIdPresent()
    {
        return $this->interfaceIdPresent;
    }
    /**
     * Set interfaceIdPresent value
     * @param string $interfaceIdPresent
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInterfaceIdPresent($interfaceIdPresent = null)
    {
        $this->interfaceIdPresent = $interfaceIdPresent;
        return $this;
    }
    /**
     * Get interfaceId value
     * @return string|null
     */
    public function getInterfaceId()
    {
        return $this->interfaceId;
    }
    /**
     * Set interfaceId value
     * @param string $interfaceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInterfaceId($interfaceId = null)
    {
        $this->interfaceId = $interfaceId;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string|null
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @param string $intraDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setIntraDelay($intraDelay = null)
    {
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get mcdnEnable value
     * @return string|null
     */
    public function getMcdnEnable()
    {
        return $this->mcdnEnable;
    }
    /**
     * Set mcdnEnable value
     * @param string $mcdnEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMcdnEnable($mcdnEnable = null)
    {
        $this->mcdnEnable = $mcdnEnable;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string|null
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @param string $numDigitsToStrip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNumDigitsToStrip($numDigitsToStrip = null)
    {
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get passingPrecedenceLevelThrough value
     * @return string|null
     */
    public function getPassingPrecedenceLevelThrough()
    {
        return $this->passingPrecedenceLevelThrough;
    }
    /**
     * Set passingPrecedenceLevelThrough value
     * @param string $passingPrecedenceLevelThrough
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPassingPrecedenceLevelThrough($passingPrecedenceLevelThrough = null)
    {
        $this->passingPrecedenceLevelThrough = $passingPrecedenceLevelThrough;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPrefix($prefix = null)
    {
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedLineIdPresentation value
     * @return string|null
     */
    public function getConnectedLineIdPresentation()
    {
        return $this->connectedLineIdPresentation;
    }
    /**
     * Set connectedLineIdPresentation value
     * @param string $connectedLineIdPresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setConnectedLineIdPresentation($connectedLineIdPresentation = null)
    {
        $this->connectedLineIdPresentation = $connectedLineIdPresentation;
        return $this;
    }
    /**
     * Get priProtocol value
     * @return string|null
     */
    public function getPriProtocol()
    {
        return $this->priProtocol;
    }
    /**
     * Set priProtocol value
     * @param string $priProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPriProtocol($priProtocol = null)
    {
        $this->priProtocol = $priProtocol;
        return $this;
    }
    /**
     * Get securityAccessLevel value
     * @return string|null
     */
    public function getSecurityAccessLevel()
    {
        return $this->securityAccessLevel;
    }
    /**
     * Set securityAccessLevel value
     * @param string $securityAccessLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSecurityAccessLevel($securityAccessLevel = null)
    {
        $this->securityAccessLevel = $securityAccessLevel;
        return $this;
    }
    /**
     * Get sendCallingNameInFacilityIe value
     * @return string|null
     */
    public function getSendCallingNameInFacilityIe()
    {
        return $this->sendCallingNameInFacilityIe;
    }
    /**
     * Set sendCallingNameInFacilityIe value
     * @param string $sendCallingNameInFacilityIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSendCallingNameInFacilityIe($sendCallingNameInFacilityIe = null)
    {
        $this->sendCallingNameInFacilityIe = $sendCallingNameInFacilityIe;
        return $this;
    }
    /**
     * Get sendExLeadingCharInDispIe value
     * @return string|null
     */
    public function getSendExLeadingCharInDispIe()
    {
        return $this->sendExLeadingCharInDispIe;
    }
    /**
     * Set sendExLeadingCharInDispIe value
     * @param string $sendExLeadingCharInDispIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSendExLeadingCharInDispIe($sendExLeadingCharInDispIe = null)
    {
        $this->sendExLeadingCharInDispIe = $sendExLeadingCharInDispIe;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string|null
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSendRestart($sendRestart = null)
    {
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string|null
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get span value
     * @return string|null
     */
    public function getSpan()
    {
        return $this->span;
    }
    /**
     * Set span value
     * @param string $span
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSpan($span = null)
    {
        $this->span = $span;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string|null
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setStatusPoll($statusPoll = null)
    {
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string|null
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @param string $smdiBasePort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSmdiBasePort($smdiBasePort = null)
    {
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get v150 value
     * @return string|null
     */
    public function getV150()
    {
        return $this->v150;
    }
    /**
     * Set v150 value
     * @param string $v150
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setV150($v150 = null)
    {
        $this->v150 = $v150;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @param string $asn1RoseOidEncoding
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = null)
    {
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get QSIGVariant value
     * @return string|null
     */
    public function getQSIGVariant()
    {
        return $this->QSIGVariant;
    }
    /**
     * Set QSIGVariant value
     * @param string $qSIGVariant
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setQSIGVariant($qSIGVariant = null)
    {
        $this->QSIGVariant = $qSIGVariant;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return $this->nationalStripDigits;
    }
    /**
     * Set nationalStripDigits value
     * @param string $nationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        $this->nationalStripDigits = $nationalStripDigits;
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return $this->internationalStripDigits;
    }
    /**
     * Set internationalStripDigits value
     * @param string $internationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        $this->internationalStripDigits = $internationalStripDigits;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @param string $unknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return $this->subscriberStripDigits;
    }
    /**
     * Set subscriberStripDigits value
     * @param string $subscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        $this->subscriberStripDigits = $subscriberStripDigits;
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return $this->nationalTransformationCssName;
    }
    /**
     * Set nationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null)
    {
        $this->nationalTransformationCssName = $nationalTransformationCssName;
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return $this->internationalTransformationCssName;
    }
    /**
     * Set internationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null)
    {
        $this->internationalTransformationCssName = $internationalTransformationCssName;
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return $this->unknownTransformationCssName;
    }
    /**
     * Set unknownTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null)
    {
        $this->unknownTransformationCssName = $unknownTransformationCssName;
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return $this->subscriberTransformationCssName;
    }
    /**
     * Set subscriberTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null)
    {
        $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = null)
    {
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = null)
    {
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = null)
    {
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = null)
    {
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPstnAccess($pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setImeE164TransformationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
