<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RApplicationServer StructType
 * @subpackage Structs
 */
class RApplicationServer extends AbstractStructBase
{
    /**
     * The appServerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Cisco Unity Voice Mail 4.x or later, Cisco Unity Connection and Cisco Web Dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddress;
    /**
     * The appUsers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers
     */
    public $appUsers;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The endUserUrl
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for Presence Server, CUMA Provisioning Server, CER Location Management
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $endUserUrl;
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: Applicable Only for Cisco Web dialer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The endUsers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers
     */
    public $endUsers;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RApplicationServer
     * @uses RApplicationServer::setAppServerType()
     * @uses RApplicationServer::setName()
     * @uses RApplicationServer::setIpAddress()
     * @uses RApplicationServer::setAppUsers()
     * @uses RApplicationServer::setUrl()
     * @uses RApplicationServer::setEndUserUrl()
     * @uses RApplicationServer::setProcessNodeName()
     * @uses RApplicationServer::setEndUsers()
     * @uses RApplicationServer::setUuid()
     * @param string $appServerType
     * @param string $name
     * @param string $ipAddress
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers
     * @param string $url
     * @param string $endUserUrl
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers
     * @param string $uuid
     */
    public function __construct($appServerType = null, $name = null, $ipAddress = null, \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers = null, $url = null, $endUserUrl = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers = null, $uuid = null)
    {
        $this
            ->setAppServerType($appServerType)
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setAppUsers($appUsers)
            ->setUrl($url)
            ->setEndUserUrl($endUserUrl)
            ->setProcessNodeName($processNodeName)
            ->setEndUsers($endUsers)
            ->setUuid($uuid);
    }
    /**
     * Get appServerType value
     * @return string|null
     */
    public function getAppServerType()
    {
        return $this->appServerType;
    }
    /**
     * Set appServerType value
     * @param string $appServerType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setAppServerType($appServerType = null)
    {
        $this->appServerType = $appServerType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get appUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers|null
     */
    public function getAppUsers()
    {
        return $this->appUsers;
    }
    /**
     * Set appUsers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setAppUsers(\\Losc\CucmBundle\Model\Webservice\StructType\AppUsers $appUsers = null)
    {
        $this->appUsers = $appUsers;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setUrl($url = null)
    {
        $this->url = $url;
        return $this;
    }
    /**
     * Get endUserUrl value
     * @return string|null
     */
    public function getEndUserUrl()
    {
        return $this->endUserUrl;
    }
    /**
     * Set endUserUrl value
     * @param string $endUserUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setEndUserUrl($endUserUrl = null)
    {
        $this->endUserUrl = $endUserUrl;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setProcessNodeName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get endUsers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers|null
     */
    public function getEndUsers()
    {
        return $this->endUsers;
    }
    /**
     * Set endUsers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setEndUsers(\\Losc\CucmBundle\Model\Webservice\StructType\EndUsers $endUsers = null)
    {
        $this->endUsers = $endUsers;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RApplicationServer
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
