<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXFkTypeProduct_Protocol StructType
 * @subpackage Structs
 */
class OXFkTypeProduct_Protocol extends OXFkType
{
    /**
     * The product
     * @var string
     */
    public $product;
    /**
     * The protocol
     * @var string
     */
    public $protocol;
    /**
     * Constructor method for OXFkTypeProduct_Protocol
     * @uses OXFkTypeProduct_Protocol::setProduct()
     * @uses OXFkTypeProduct_Protocol::setProtocol()
     * @param string $product
     * @param string $protocol
     */
    public function __construct($product = null, $protocol = null)
    {
        $this
            ->setProduct($product)
            ->setProtocol($protocol);
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\OXFkTypeProduct_Protocol
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
}
