<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipProfile StructType
 * @subpackage Structs
 */
class LSipProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The defaultTelephonyEventPayloadType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultTelephonyEventPayloadType;
    /**
     * The redirectByApplication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectByApplication;
    /**
     * The ringing180
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ringing180;
    /**
     * The timerInvite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerInvite;
    /**
     * The timerRegisterDelta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegisterDelta;
    /**
     * The timerRegister
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegister;
    /**
     * The timerT1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT1;
    /**
     * The timerT2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT2;
    /**
     * The retryInvite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryInvite;
    /**
     * The retryNotInvite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryNotInvite;
    /**
     * The startMediaPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startMediaPort;
    /**
     * The stopMediaPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stopMediaPort;
    /**
     * The callpickupListUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callpickupListUri;
    /**
     * The callpickupGroupUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callpickupGroupUri;
    /**
     * The meetmeServiceUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $meetmeServiceUrl;
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telnetLevel;
    /**
     * The timerKeepAlive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerKeepAlive;
    /**
     * The timerSubscribe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribe;
    /**
     * The timerSubscribeDelta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribeDelta;
    /**
     * The maxRedirects
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxRedirects;
    /**
     * The timerOffHookToFirstDigit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerOffHookToFirstDigit;
    /**
     * The callForwardUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callForwardUri;
    /**
     * The abbreviatedDialUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $abbreviatedDialUri;
    /**
     * The confJointEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $confJointEnable;
    /**
     * The rfc2543Hold
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2543Hold;
    /**
     * The semiAttendedTransfer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $semiAttendedTransfer;
    /**
     * The enableVad
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableVad;
    /**
     * The stutterMsgWaiting
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $stutterMsgWaiting;
    /**
     * The callStats
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callStats;
    /**
     * The t38Invite
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $t38Invite;
    /**
     * The rerouteIncomingRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The enableAnatForEarlyOfferCalls
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableAnatForEarlyOfferCalls;
    /**
     * The rsvpOverSip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rsvpOverSip;
    /**
     * The fallbackToLocalRsvp
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fallbackToLocalRsvp;
    /**
     * The sipRe11XxEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gClear;
    /**
     * The sendRecvSDPInMidCallInvite
     * Meta information extracted from the WSDL
     * - documentation: This field is editable only if earlyOfferSupportForVoiceCall is set to true.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRecvSDPInMidCallInvite;
    /**
     * The enableOutboundOptionsPing
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundOptionsPing;
    /**
     * The optionsPingIntervalWhenStatusOK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusOK;
    /**
     * The optionsPingIntervalWhenStatusNotOK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusNotOK;
    /**
     * The deliverConferenceBridgeIdentifier
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $deliverConferenceBridgeIdentifier;
    /**
     * The sipOptionsRetryCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryCount;
    /**
     * The sipOptionsRetryTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryTimer;
    /**
     * The sipBandwidthModifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipBandwidthModifier;
    /**
     * The enableUriOutdialSupport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableUriOutdialSupport;
    /**
     * The userAgentServerHeaderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userAgentServerHeaderInfo;
    /**
     * The allowPresentationSharingUsingBfcp
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowPresentationSharingUsingBfcp;
    /**
     * The scriptParameters
     * Meta information extracted from the WSDL
     * - documentation: This field will be enabled only when SIP Normalization Script is present.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scriptParameters;
    /**
     * The isScriptTraceEnabled
     * Meta information extracted from the WSDL
     * - documentation: This field will be enabled only when SIP Normalization Script is present.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isScriptTraceEnabled;
    /**
     * The sipNormalizationScript
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipNormalizationScript;
    /**
     * The allowiXApplicationMedia
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicationMedia;
    /**
     * The dialStringInterpretation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acceptAudioCodecPreferences;
    /**
     * The mlppUserAuthorization
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mlppUserAuthorization;
    /**
     * The isAssuredSipServiceEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAssuredSipServiceEnabled;
    /**
     * The resourcePriorityNamespace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerName
     * Meta information extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerName;
    /**
     * The callingLineIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdentification;
    /**
     * The rejectAnonymousIncomingCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousIncomingCall;
    /**
     * The callpickupUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callpickupUri;
    /**
     * The rejectAnonymousOutgoingCall
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousOutgoingCall;
    /**
     * The videoCallTrafficClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta information extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sdpTransparency;
    /**
     * The allowMultipleCodecs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowMultipleCodecs;
    /**
     * The sipSessionRefreshMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The destRouteString
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destRouteString;
    /**
     * The inactiveSDPRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $inactiveSDPRequired;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipProfile
     * @uses LSipProfile::setName()
     * @uses LSipProfile::setDescription()
     * @uses LSipProfile::setDefaultTelephonyEventPayloadType()
     * @uses LSipProfile::setRedirectByApplication()
     * @uses LSipProfile::setRinging180()
     * @uses LSipProfile::setTimerInvite()
     * @uses LSipProfile::setTimerRegisterDelta()
     * @uses LSipProfile::setTimerRegister()
     * @uses LSipProfile::setTimerT1()
     * @uses LSipProfile::setTimerT2()
     * @uses LSipProfile::setRetryInvite()
     * @uses LSipProfile::setRetryNotInvite()
     * @uses LSipProfile::setStartMediaPort()
     * @uses LSipProfile::setStopMediaPort()
     * @uses LSipProfile::setCallpickupListUri()
     * @uses LSipProfile::setCallpickupGroupUri()
     * @uses LSipProfile::setMeetmeServiceUrl()
     * @uses LSipProfile::setUserInfo()
     * @uses LSipProfile::setDtmfDbLevel()
     * @uses LSipProfile::setCallHoldRingback()
     * @uses LSipProfile::setAnonymousCallBlock()
     * @uses LSipProfile::setCallerIdBlock()
     * @uses LSipProfile::setDndControl()
     * @uses LSipProfile::setTelnetLevel()
     * @uses LSipProfile::setTimerKeepAlive()
     * @uses LSipProfile::setTimerSubscribe()
     * @uses LSipProfile::setTimerSubscribeDelta()
     * @uses LSipProfile::setMaxRedirects()
     * @uses LSipProfile::setTimerOffHookToFirstDigit()
     * @uses LSipProfile::setCallForwardUri()
     * @uses LSipProfile::setAbbreviatedDialUri()
     * @uses LSipProfile::setConfJointEnable()
     * @uses LSipProfile::setRfc2543Hold()
     * @uses LSipProfile::setSemiAttendedTransfer()
     * @uses LSipProfile::setEnableVad()
     * @uses LSipProfile::setStutterMsgWaiting()
     * @uses LSipProfile::setCallStats()
     * @uses LSipProfile::setT38Invite()
     * @uses LSipProfile::setRerouteIncomingRequest()
     * @uses LSipProfile::setResourcePriorityNamespaceListName()
     * @uses LSipProfile::setEnableAnatForEarlyOfferCalls()
     * @uses LSipProfile::setRsvpOverSip()
     * @uses LSipProfile::setFallbackToLocalRsvp()
     * @uses LSipProfile::setSipRe11XxEnabled()
     * @uses LSipProfile::setGClear()
     * @uses LSipProfile::setSendRecvSDPInMidCallInvite()
     * @uses LSipProfile::setEnableOutboundOptionsPing()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusOK()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusNotOK()
     * @uses LSipProfile::setDeliverConferenceBridgeIdentifier()
     * @uses LSipProfile::setSipOptionsRetryCount()
     * @uses LSipProfile::setSipOptionsRetryTimer()
     * @uses LSipProfile::setSipBandwidthModifier()
     * @uses LSipProfile::setEnableUriOutdialSupport()
     * @uses LSipProfile::setUserAgentServerHeaderInfo()
     * @uses LSipProfile::setAllowPresentationSharingUsingBfcp()
     * @uses LSipProfile::setScriptParameters()
     * @uses LSipProfile::setIsScriptTraceEnabled()
     * @uses LSipProfile::setSipNormalizationScript()
     * @uses LSipProfile::setAllowiXApplicationMedia()
     * @uses LSipProfile::setDialStringInterpretation()
     * @uses LSipProfile::setAcceptAudioCodecPreferences()
     * @uses LSipProfile::setMlppUserAuthorization()
     * @uses LSipProfile::setIsAssuredSipServiceEnabled()
     * @uses LSipProfile::setResourcePriorityNamespace()
     * @uses LSipProfile::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses LSipProfile::setCallerIdDn()
     * @uses LSipProfile::setCallerName()
     * @uses LSipProfile::setCallingLineIdentification()
     * @uses LSipProfile::setRejectAnonymousIncomingCall()
     * @uses LSipProfile::setCallpickupUri()
     * @uses LSipProfile::setRejectAnonymousOutgoingCall()
     * @uses LSipProfile::setVideoCallTrafficClass()
     * @uses LSipProfile::setSdpTransparency()
     * @uses LSipProfile::setAllowMultipleCodecs()
     * @uses LSipProfile::setSipSessionRefreshMethod()
     * @uses LSipProfile::setEarlyOfferSuppVoiceCall()
     * @uses LSipProfile::setCucmVersionInSipHeader()
     * @uses LSipProfile::setConfidentialAccessLevelHeaders()
     * @uses LSipProfile::setDestRouteString()
     * @uses LSipProfile::setInactiveSDPRequired()
     * @uses LSipProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $defaultTelephonyEventPayloadType
     * @param string $redirectByApplication
     * @param string $ringing180
     * @param string $timerInvite
     * @param string $timerRegisterDelta
     * @param string $timerRegister
     * @param string $timerT1
     * @param string $timerT2
     * @param string $retryInvite
     * @param string $retryNotInvite
     * @param string $startMediaPort
     * @param string $stopMediaPort
     * @param string $callpickupListUri
     * @param string $callpickupGroupUri
     * @param string $meetmeServiceUrl
     * @param string $userInfo
     * @param string $dtmfDbLevel
     * @param string $callHoldRingback
     * @param string $anonymousCallBlock
     * @param string $callerIdBlock
     * @param string $dndControl
     * @param string $telnetLevel
     * @param string $timerKeepAlive
     * @param string $timerSubscribe
     * @param string $timerSubscribeDelta
     * @param string $maxRedirects
     * @param string $timerOffHookToFirstDigit
     * @param string $callForwardUri
     * @param string $abbreviatedDialUri
     * @param string $confJointEnable
     * @param string $rfc2543Hold
     * @param string $semiAttendedTransfer
     * @param string $enableVad
     * @param string $stutterMsgWaiting
     * @param string $callStats
     * @param string $t38Invite
     * @param string $rerouteIncomingRequest
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceListName
     * @param string $enableAnatForEarlyOfferCalls
     * @param string $rsvpOverSip
     * @param string $fallbackToLocalRsvp
     * @param string $sipRe11XxEnabled
     * @param string $gClear
     * @param string $sendRecvSDPInMidCallInvite
     * @param string $enableOutboundOptionsPing
     * @param string $optionsPingIntervalWhenStatusOK
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @param string $deliverConferenceBridgeIdentifier
     * @param string $sipOptionsRetryCount
     * @param string $sipOptionsRetryTimer
     * @param string $sipBandwidthModifier
     * @param string $enableUriOutdialSupport
     * @param string $userAgentServerHeaderInfo
     * @param string $allowPresentationSharingUsingBfcp
     * @param string $scriptParameters
     * @param string $isScriptTraceEnabled
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScript
     * @param string $allowiXApplicationMedia
     * @param string $dialStringInterpretation
     * @param string $acceptAudioCodecPreferences
     * @param string $mlppUserAuthorization
     * @param string $isAssuredSipServiceEnabled
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespace
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $callerIdDn
     * @param string $callerName
     * @param string $callingLineIdentification
     * @param string $rejectAnonymousIncomingCall
     * @param string $callpickupUri
     * @param string $rejectAnonymousOutgoingCall
     * @param string $videoCallTrafficClass
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sdpTransparency
     * @param string $allowMultipleCodecs
     * @param string $sipSessionRefreshMethod
     * @param string $earlyOfferSuppVoiceCall
     * @param string $cucmVersionInSipHeader
     * @param string $confidentialAccessLevelHeaders
     * @param string $destRouteString
     * @param string $inactiveSDPRequired
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $defaultTelephonyEventPayloadType = null, $redirectByApplication = null, $ringing180 = null, $timerInvite = null, $timerRegisterDelta = null, $timerRegister = null, $timerT1 = null, $timerT2 = null, $retryInvite = null, $retryNotInvite = null, $startMediaPort = null, $stopMediaPort = null, $callpickupListUri = null, $callpickupGroupUri = null, $meetmeServiceUrl = null, $userInfo = null, $dtmfDbLevel = null, $callHoldRingback = null, $anonymousCallBlock = null, $callerIdBlock = null, $dndControl = null, $telnetLevel = null, $timerKeepAlive = null, $timerSubscribe = null, $timerSubscribeDelta = null, $maxRedirects = null, $timerOffHookToFirstDigit = null, $callForwardUri = null, $abbreviatedDialUri = null, $confJointEnable = null, $rfc2543Hold = null, $semiAttendedTransfer = null, $enableVad = null, $stutterMsgWaiting = null, $callStats = null, $t38Invite = null, $rerouteIncomingRequest = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceListName = null, $enableAnatForEarlyOfferCalls = null, $rsvpOverSip = null, $fallbackToLocalRsvp = null, $sipRe11XxEnabled = null, $gClear = null, $sendRecvSDPInMidCallInvite = null, $enableOutboundOptionsPing = null, $optionsPingIntervalWhenStatusOK = null, $optionsPingIntervalWhenStatusNotOK = null, $deliverConferenceBridgeIdentifier = null, $sipOptionsRetryCount = null, $sipOptionsRetryTimer = null, $sipBandwidthModifier = null, $enableUriOutdialSupport = null, $userAgentServerHeaderInfo = null, $allowPresentationSharingUsingBfcp = null, $scriptParameters = null, $isScriptTraceEnabled = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScript = null, $allowiXApplicationMedia = null, $dialStringInterpretation = null, $acceptAudioCodecPreferences = null, $mlppUserAuthorization = null, $isAssuredSipServiceEnabled = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespace = null, $useCallerIdCallerNameinUriOutgoingRequest = null, $callerIdDn = null, $callerName = null, $callingLineIdentification = null, $rejectAnonymousIncomingCall = null, $callpickupUri = null, $rejectAnonymousOutgoingCall = null, $videoCallTrafficClass = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sdpTransparency = null, $allowMultipleCodecs = null, $sipSessionRefreshMethod = null, $earlyOfferSuppVoiceCall = null, $cucmVersionInSipHeader = null, $confidentialAccessLevelHeaders = null, $destRouteString = null, $inactiveSDPRequired = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType)
            ->setRedirectByApplication($redirectByApplication)
            ->setRinging180($ringing180)
            ->setTimerInvite($timerInvite)
            ->setTimerRegisterDelta($timerRegisterDelta)
            ->setTimerRegister($timerRegister)
            ->setTimerT1($timerT1)
            ->setTimerT2($timerT2)
            ->setRetryInvite($retryInvite)
            ->setRetryNotInvite($retryNotInvite)
            ->setStartMediaPort($startMediaPort)
            ->setStopMediaPort($stopMediaPort)
            ->setCallpickupListUri($callpickupListUri)
            ->setCallpickupGroupUri($callpickupGroupUri)
            ->setMeetmeServiceUrl($meetmeServiceUrl)
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setTimerKeepAlive($timerKeepAlive)
            ->setTimerSubscribe($timerSubscribe)
            ->setTimerSubscribeDelta($timerSubscribeDelta)
            ->setMaxRedirects($maxRedirects)
            ->setTimerOffHookToFirstDigit($timerOffHookToFirstDigit)
            ->setCallForwardUri($callForwardUri)
            ->setAbbreviatedDialUri($abbreviatedDialUri)
            ->setConfJointEnable($confJointEnable)
            ->setRfc2543Hold($rfc2543Hold)
            ->setSemiAttendedTransfer($semiAttendedTransfer)
            ->setEnableVad($enableVad)
            ->setStutterMsgWaiting($stutterMsgWaiting)
            ->setCallStats($callStats)
            ->setT38Invite($t38Invite)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls)
            ->setRsvpOverSip($rsvpOverSip)
            ->setFallbackToLocalRsvp($fallbackToLocalRsvp)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite)
            ->setEnableOutboundOptionsPing($enableOutboundOptionsPing)
            ->setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK)
            ->setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK)
            ->setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier)
            ->setSipOptionsRetryCount($sipOptionsRetryCount)
            ->setSipOptionsRetryTimer($sipOptionsRetryTimer)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setEnableUriOutdialSupport($enableUriOutdialSupport)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setScriptParameters($scriptParameters)
            ->setIsScriptTraceEnabled($isScriptTraceEnabled)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setAllowiXApplicationMedia($allowiXApplicationMedia)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setMlppUserAuthorization($mlppUserAuthorization)
            ->setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setCallerIdDn($callerIdDn)
            ->setCallerName($callerName)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall)
            ->setCallpickupUri($callpickupUri)
            ->setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setAllowMultipleCodecs($allowMultipleCodecs)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setDestRouteString($destRouteString)
            ->setInactiveSDPRequired($inactiveSDPRequired)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get defaultTelephonyEventPayloadType value
     * @return string|null
     */
    public function getDefaultTelephonyEventPayloadType()
    {
        return $this->defaultTelephonyEventPayloadType;
    }
    /**
     * Set defaultTelephonyEventPayloadType value
     * @param string $defaultTelephonyEventPayloadType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType = null)
    {
        $this->defaultTelephonyEventPayloadType = $defaultTelephonyEventPayloadType;
        return $this;
    }
    /**
     * Get redirectByApplication value
     * @return string|null
     */
    public function getRedirectByApplication()
    {
        return $this->redirectByApplication;
    }
    /**
     * Set redirectByApplication value
     * @param string $redirectByApplication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRedirectByApplication($redirectByApplication = null)
    {
        $this->redirectByApplication = $redirectByApplication;
        return $this;
    }
    /**
     * Get ringing180 value
     * @return string|null
     */
    public function getRinging180()
    {
        return $this->ringing180;
    }
    /**
     * Set ringing180 value
     * @param string $ringing180
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRinging180($ringing180 = null)
    {
        $this->ringing180 = $ringing180;
        return $this;
    }
    /**
     * Get timerInvite value
     * @return string|null
     */
    public function getTimerInvite()
    {
        return $this->timerInvite;
    }
    /**
     * Set timerInvite value
     * @param string $timerInvite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerInvite($timerInvite = null)
    {
        $this->timerInvite = $timerInvite;
        return $this;
    }
    /**
     * Get timerRegisterDelta value
     * @return string|null
     */
    public function getTimerRegisterDelta()
    {
        return $this->timerRegisterDelta;
    }
    /**
     * Set timerRegisterDelta value
     * @param string $timerRegisterDelta
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerRegisterDelta($timerRegisterDelta = null)
    {
        $this->timerRegisterDelta = $timerRegisterDelta;
        return $this;
    }
    /**
     * Get timerRegister value
     * @return string|null
     */
    public function getTimerRegister()
    {
        return $this->timerRegister;
    }
    /**
     * Set timerRegister value
     * @param string $timerRegister
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerRegister($timerRegister = null)
    {
        $this->timerRegister = $timerRegister;
        return $this;
    }
    /**
     * Get timerT1 value
     * @return string|null
     */
    public function getTimerT1()
    {
        return $this->timerT1;
    }
    /**
     * Set timerT1 value
     * @param string $timerT1
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerT1($timerT1 = null)
    {
        $this->timerT1 = $timerT1;
        return $this;
    }
    /**
     * Get timerT2 value
     * @return string|null
     */
    public function getTimerT2()
    {
        return $this->timerT2;
    }
    /**
     * Set timerT2 value
     * @param string $timerT2
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerT2($timerT2 = null)
    {
        $this->timerT2 = $timerT2;
        return $this;
    }
    /**
     * Get retryInvite value
     * @return string|null
     */
    public function getRetryInvite()
    {
        return $this->retryInvite;
    }
    /**
     * Set retryInvite value
     * @param string $retryInvite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRetryInvite($retryInvite = null)
    {
        $this->retryInvite = $retryInvite;
        return $this;
    }
    /**
     * Get retryNotInvite value
     * @return string|null
     */
    public function getRetryNotInvite()
    {
        return $this->retryNotInvite;
    }
    /**
     * Set retryNotInvite value
     * @param string $retryNotInvite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRetryNotInvite($retryNotInvite = null)
    {
        $this->retryNotInvite = $retryNotInvite;
        return $this;
    }
    /**
     * Get startMediaPort value
     * @return string|null
     */
    public function getStartMediaPort()
    {
        return $this->startMediaPort;
    }
    /**
     * Set startMediaPort value
     * @param string $startMediaPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setStartMediaPort($startMediaPort = null)
    {
        $this->startMediaPort = $startMediaPort;
        return $this;
    }
    /**
     * Get stopMediaPort value
     * @return string|null
     */
    public function getStopMediaPort()
    {
        return $this->stopMediaPort;
    }
    /**
     * Set stopMediaPort value
     * @param string $stopMediaPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setStopMediaPort($stopMediaPort = null)
    {
        $this->stopMediaPort = $stopMediaPort;
        return $this;
    }
    /**
     * Get callpickupListUri value
     * @return string|null
     */
    public function getCallpickupListUri()
    {
        return $this->callpickupListUri;
    }
    /**
     * Set callpickupListUri value
     * @param string $callpickupListUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallpickupListUri($callpickupListUri = null)
    {
        $this->callpickupListUri = $callpickupListUri;
        return $this;
    }
    /**
     * Get callpickupGroupUri value
     * @return string|null
     */
    public function getCallpickupGroupUri()
    {
        return $this->callpickupGroupUri;
    }
    /**
     * Set callpickupGroupUri value
     * @param string $callpickupGroupUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallpickupGroupUri($callpickupGroupUri = null)
    {
        $this->callpickupGroupUri = $callpickupGroupUri;
        return $this;
    }
    /**
     * Get meetmeServiceUrl value
     * @return string|null
     */
    public function getMeetmeServiceUrl()
    {
        return $this->meetmeServiceUrl;
    }
    /**
     * Set meetmeServiceUrl value
     * @param string $meetmeServiceUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setMeetmeServiceUrl($meetmeServiceUrl = null)
    {
        $this->meetmeServiceUrl = $meetmeServiceUrl;
        return $this;
    }
    /**
     * Get userInfo value
     * @return string|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @param string $userInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setUserInfo($userInfo = null)
    {
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return string|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @param string $dtmfDbLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDtmfDbLevel($dtmfDbLevel = null)
    {
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return string|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @param string $callHoldRingback
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallHoldRingback($callHoldRingback = null)
    {
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return string|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @param string $anonymousCallBlock
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setAnonymousCallBlock($anonymousCallBlock = null)
    {
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return string|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @param string $callerIdBlock
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallerIdBlock($callerIdBlock = null)
    {
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return string|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @param string $dndControl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDndControl($dndControl = null)
    {
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return string|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @param string $telnetLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTelnetLevel($telnetLevel = null)
    {
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get timerKeepAlive value
     * @return string|null
     */
    public function getTimerKeepAlive()
    {
        return $this->timerKeepAlive;
    }
    /**
     * Set timerKeepAlive value
     * @param string $timerKeepAlive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerKeepAlive($timerKeepAlive = null)
    {
        $this->timerKeepAlive = $timerKeepAlive;
        return $this;
    }
    /**
     * Get timerSubscribe value
     * @return string|null
     */
    public function getTimerSubscribe()
    {
        return $this->timerSubscribe;
    }
    /**
     * Set timerSubscribe value
     * @param string $timerSubscribe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerSubscribe($timerSubscribe = null)
    {
        $this->timerSubscribe = $timerSubscribe;
        return $this;
    }
    /**
     * Get timerSubscribeDelta value
     * @return string|null
     */
    public function getTimerSubscribeDelta()
    {
        return $this->timerSubscribeDelta;
    }
    /**
     * Set timerSubscribeDelta value
     * @param string $timerSubscribeDelta
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerSubscribeDelta($timerSubscribeDelta = null)
    {
        $this->timerSubscribeDelta = $timerSubscribeDelta;
        return $this;
    }
    /**
     * Get maxRedirects value
     * @return string|null
     */
    public function getMaxRedirects()
    {
        return $this->maxRedirects;
    }
    /**
     * Set maxRedirects value
     * @param string $maxRedirects
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setMaxRedirects($maxRedirects = null)
    {
        $this->maxRedirects = $maxRedirects;
        return $this;
    }
    /**
     * Get timerOffHookToFirstDigit value
     * @return string|null
     */
    public function getTimerOffHookToFirstDigit()
    {
        return $this->timerOffHookToFirstDigit;
    }
    /**
     * Set timerOffHookToFirstDigit value
     * @param string $timerOffHookToFirstDigit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setTimerOffHookToFirstDigit($timerOffHookToFirstDigit = null)
    {
        $this->timerOffHookToFirstDigit = $timerOffHookToFirstDigit;
        return $this;
    }
    /**
     * Get callForwardUri value
     * @return string|null
     */
    public function getCallForwardUri()
    {
        return $this->callForwardUri;
    }
    /**
     * Set callForwardUri value
     * @param string $callForwardUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallForwardUri($callForwardUri = null)
    {
        $this->callForwardUri = $callForwardUri;
        return $this;
    }
    /**
     * Get abbreviatedDialUri value
     * @return string|null
     */
    public function getAbbreviatedDialUri()
    {
        return $this->abbreviatedDialUri;
    }
    /**
     * Set abbreviatedDialUri value
     * @param string $abbreviatedDialUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setAbbreviatedDialUri($abbreviatedDialUri = null)
    {
        $this->abbreviatedDialUri = $abbreviatedDialUri;
        return $this;
    }
    /**
     * Get confJointEnable value
     * @return string|null
     */
    public function getConfJointEnable()
    {
        return $this->confJointEnable;
    }
    /**
     * Set confJointEnable value
     * @param string $confJointEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setConfJointEnable($confJointEnable = null)
    {
        $this->confJointEnable = $confJointEnable;
        return $this;
    }
    /**
     * Get rfc2543Hold value
     * @return string|null
     */
    public function getRfc2543Hold()
    {
        return $this->rfc2543Hold;
    }
    /**
     * Set rfc2543Hold value
     * @param string $rfc2543Hold
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRfc2543Hold($rfc2543Hold = null)
    {
        $this->rfc2543Hold = $rfc2543Hold;
        return $this;
    }
    /**
     * Get semiAttendedTransfer value
     * @return string|null
     */
    public function getSemiAttendedTransfer()
    {
        return $this->semiAttendedTransfer;
    }
    /**
     * Set semiAttendedTransfer value
     * @param string $semiAttendedTransfer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSemiAttendedTransfer($semiAttendedTransfer = null)
    {
        $this->semiAttendedTransfer = $semiAttendedTransfer;
        return $this;
    }
    /**
     * Get enableVad value
     * @return string|null
     */
    public function getEnableVad()
    {
        return $this->enableVad;
    }
    /**
     * Set enableVad value
     * @param string $enableVad
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setEnableVad($enableVad = null)
    {
        $this->enableVad = $enableVad;
        return $this;
    }
    /**
     * Get stutterMsgWaiting value
     * @return string|null
     */
    public function getStutterMsgWaiting()
    {
        return $this->stutterMsgWaiting;
    }
    /**
     * Set stutterMsgWaiting value
     * @param string $stutterMsgWaiting
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setStutterMsgWaiting($stutterMsgWaiting = null)
    {
        $this->stutterMsgWaiting = $stutterMsgWaiting;
        return $this;
    }
    /**
     * Get callStats value
     * @return string|null
     */
    public function getCallStats()
    {
        return $this->callStats;
    }
    /**
     * Set callStats value
     * @param string $callStats
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallStats($callStats = null)
    {
        $this->callStats = $callStats;
        return $this;
    }
    /**
     * Get t38Invite value
     * @return string|null
     */
    public function getT38Invite()
    {
        return $this->t38Invite;
    }
    /**
     * Set t38Invite value
     * @param string $t38Invite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setT38Invite($t38Invite = null)
    {
        $this->t38Invite = $t38Invite;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return string|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @param string $rerouteIncomingRequest
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRerouteIncomingRequest($rerouteIncomingRequest = null)
    {
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setResourcePriorityNamespaceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get enableAnatForEarlyOfferCalls value
     * @return string|null
     */
    public function getEnableAnatForEarlyOfferCalls()
    {
        return $this->enableAnatForEarlyOfferCalls;
    }
    /**
     * Set enableAnatForEarlyOfferCalls value
     * @param string $enableAnatForEarlyOfferCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls = null)
    {
        $this->enableAnatForEarlyOfferCalls = $enableAnatForEarlyOfferCalls;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return string|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @param string $rsvpOverSip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRsvpOverSip($rsvpOverSip = null)
    {
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get fallbackToLocalRsvp value
     * @return string|null
     */
    public function getFallbackToLocalRsvp()
    {
        return $this->fallbackToLocalRsvp;
    }
    /**
     * Set fallbackToLocalRsvp value
     * @param string $fallbackToLocalRsvp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setFallbackToLocalRsvp($fallbackToLocalRsvp = null)
    {
        $this->fallbackToLocalRsvp = $fallbackToLocalRsvp;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return string|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @param string $sipRe11XxEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSipRe11XxEnabled($sipRe11XxEnabled = null)
    {
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return string|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @param string $gClear
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setGClear($gClear = null)
    {
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sendRecvSDPInMidCallInvite value
     * @return string|null
     */
    public function getSendRecvSDPInMidCallInvite()
    {
        return $this->sendRecvSDPInMidCallInvite;
    }
    /**
     * Set sendRecvSDPInMidCallInvite value
     * @param string $sendRecvSDPInMidCallInvite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite = null)
    {
        $this->sendRecvSDPInMidCallInvite = $sendRecvSDPInMidCallInvite;
        return $this;
    }
    /**
     * Get enableOutboundOptionsPing value
     * @return string|null
     */
    public function getEnableOutboundOptionsPing()
    {
        return $this->enableOutboundOptionsPing;
    }
    /**
     * Set enableOutboundOptionsPing value
     * @param string $enableOutboundOptionsPing
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setEnableOutboundOptionsPing($enableOutboundOptionsPing = null)
    {
        $this->enableOutboundOptionsPing = $enableOutboundOptionsPing;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusOK()
    {
        return $this->optionsPingIntervalWhenStatusOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusOK value
     * @param string $optionsPingIntervalWhenStatusOK
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK = null)
    {
        $this->optionsPingIntervalWhenStatusOK = $optionsPingIntervalWhenStatusOK;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusNotOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusNotOK()
    {
        return $this->optionsPingIntervalWhenStatusNotOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusNotOK value
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK = null)
    {
        $this->optionsPingIntervalWhenStatusNotOK = $optionsPingIntervalWhenStatusNotOK;
        return $this;
    }
    /**
     * Get deliverConferenceBridgeIdentifier value
     * @return string|null
     */
    public function getDeliverConferenceBridgeIdentifier()
    {
        return $this->deliverConferenceBridgeIdentifier;
    }
    /**
     * Set deliverConferenceBridgeIdentifier value
     * @param string $deliverConferenceBridgeIdentifier
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier = null)
    {
        $this->deliverConferenceBridgeIdentifier = $deliverConferenceBridgeIdentifier;
        return $this;
    }
    /**
     * Get sipOptionsRetryCount value
     * @return string|null
     */
    public function getSipOptionsRetryCount()
    {
        return $this->sipOptionsRetryCount;
    }
    /**
     * Set sipOptionsRetryCount value
     * @param string $sipOptionsRetryCount
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSipOptionsRetryCount($sipOptionsRetryCount = null)
    {
        $this->sipOptionsRetryCount = $sipOptionsRetryCount;
        return $this;
    }
    /**
     * Get sipOptionsRetryTimer value
     * @return string|null
     */
    public function getSipOptionsRetryTimer()
    {
        return $this->sipOptionsRetryTimer;
    }
    /**
     * Set sipOptionsRetryTimer value
     * @param string $sipOptionsRetryTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSipOptionsRetryTimer($sipOptionsRetryTimer = null)
    {
        $this->sipOptionsRetryTimer = $sipOptionsRetryTimer;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return string|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @param string $sipBandwidthModifier
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSipBandwidthModifier($sipBandwidthModifier = null)
    {
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get enableUriOutdialSupport value
     * @return string|null
     */
    public function getEnableUriOutdialSupport()
    {
        return $this->enableUriOutdialSupport;
    }
    /**
     * Set enableUriOutdialSupport value
     * @param string $enableUriOutdialSupport
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setEnableUriOutdialSupport($enableUriOutdialSupport = null)
    {
        $this->enableUriOutdialSupport = $enableUriOutdialSupport;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return string|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @param string $userAgentServerHeaderInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setUserAgentServerHeaderInfo($userAgentServerHeaderInfo = null)
    {
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get allowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->allowPresentationSharingUsingBfcp;
    }
    /**
     * Set allowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        $this->allowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setScriptParameters($scriptParameters = null)
    {
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get isScriptTraceEnabled value
     * @return string|null
     */
    public function getIsScriptTraceEnabled()
    {
        return $this->isScriptTraceEnabled;
    }
    /**
     * Set isScriptTraceEnabled value
     * @param string $isScriptTraceEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setIsScriptTraceEnabled($isScriptTraceEnabled = null)
    {
        $this->isScriptTraceEnabled = $isScriptTraceEnabled;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScript
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSipNormalizationScript(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get allowiXApplicationMedia value
     * @return string|null
     */
    public function getAllowiXApplicationMedia()
    {
        return $this->allowiXApplicationMedia;
    }
    /**
     * Set allowiXApplicationMedia value
     * @param string $allowiXApplicationMedia
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setAllowiXApplicationMedia($allowiXApplicationMedia = null)
    {
        $this->allowiXApplicationMedia = $allowiXApplicationMedia;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return string|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @param string $dialStringInterpretation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDialStringInterpretation($dialStringInterpretation = null)
    {
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return string|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @param string $acceptAudioCodecPreferences
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setAcceptAudioCodecPreferences($acceptAudioCodecPreferences = null)
    {
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get mlppUserAuthorization value
     * @return string|null
     */
    public function getMlppUserAuthorization()
    {
        return $this->mlppUserAuthorization;
    }
    /**
     * Set mlppUserAuthorization value
     * @param string $mlppUserAuthorization
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setMlppUserAuthorization($mlppUserAuthorization = null)
    {
        $this->mlppUserAuthorization = $mlppUserAuthorization;
        return $this;
    }
    /**
     * Get isAssuredSipServiceEnabled value
     * @return string|null
     */
    public function getIsAssuredSipServiceEnabled()
    {
        return $this->isAssuredSipServiceEnabled;
    }
    /**
     * Set isAssuredSipServiceEnabled value
     * @param string $isAssuredSipServiceEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled = null)
    {
        $this->isAssuredSipServiceEnabled = $isAssuredSipServiceEnabled;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setResourcePriorityNamespace(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallerName($callerName = null)
    {
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return string|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @param string $callingLineIdentification
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallingLineIdentification($callingLineIdentification = null)
    {
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get rejectAnonymousIncomingCall value
     * @return string|null
     */
    public function getRejectAnonymousIncomingCall()
    {
        return $this->rejectAnonymousIncomingCall;
    }
    /**
     * Set rejectAnonymousIncomingCall value
     * @param string $rejectAnonymousIncomingCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall = null)
    {
        $this->rejectAnonymousIncomingCall = $rejectAnonymousIncomingCall;
        return $this;
    }
    /**
     * Get callpickupUri value
     * @return string|null
     */
    public function getCallpickupUri()
    {
        return $this->callpickupUri;
    }
    /**
     * Set callpickupUri value
     * @param string $callpickupUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCallpickupUri($callpickupUri = null)
    {
        $this->callpickupUri = $callpickupUri;
        return $this;
    }
    /**
     * Get rejectAnonymousOutgoingCall value
     * @return string|null
     */
    public function getRejectAnonymousOutgoingCall()
    {
        return $this->rejectAnonymousOutgoingCall;
    }
    /**
     * Set rejectAnonymousOutgoingCall value
     * @param string $rejectAnonymousOutgoingCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall = null)
    {
        $this->rejectAnonymousOutgoingCall = $rejectAnonymousOutgoingCall;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return string|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @param string $videoCallTrafficClass
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setVideoCallTrafficClass($videoCallTrafficClass = null)
    {
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSdpTransparency()
    {
        return $this->sdpTransparency;
    }
    /**
     * Set sdpTransparency value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sdpTransparency
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSdpTransparency(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sdpTransparency = null)
    {
        $this->sdpTransparency = $sdpTransparency;
        return $this;
    }
    /**
     * Get allowMultipleCodecs value
     * @return string|null
     */
    public function getAllowMultipleCodecs()
    {
        return $this->allowMultipleCodecs;
    }
    /**
     * Set allowMultipleCodecs value
     * @param string $allowMultipleCodecs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setAllowMultipleCodecs($allowMultipleCodecs = null)
    {
        $this->allowMultipleCodecs = $allowMultipleCodecs;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return string|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @param string $sipSessionRefreshMethod
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setSipSessionRefreshMethod($sipSessionRefreshMethod = null)
    {
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @param string $earlyOfferSuppVoiceCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall = null)
    {
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return string|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @param string $cucmVersionInSipHeader
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setCucmVersionInSipHeader($cucmVersionInSipHeader = null)
    {
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return string|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @param string $confidentialAccessLevelHeaders
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders = null)
    {
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get destRouteString value
     * @return string|null
     */
    public function getDestRouteString()
    {
        return $this->destRouteString;
    }
    /**
     * Set destRouteString value
     * @param string $destRouteString
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setDestRouteString($destRouteString = null)
    {
        $this->destRouteString = $destRouteString;
        return $this;
    }
    /**
     * Get inactiveSDPRequired value
     * @return string|null
     */
    public function getInactiveSDPRequired()
    {
        return $this->inactiveSDPRequired;
    }
    /**
     * Set inactiveSDPRequired value
     * @param string $inactiveSDPRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setInactiveSDPRequired($inactiveSDPRequired = null)
    {
        $this->inactiveSDPRequired = $inactiveSDPRequired;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LSipProfile
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
