<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class LBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The directedCallParkId
     * Meta information extracted from the WSDL
     * - documentation: Only the uuid attribute is read
     * - base: xsd:string
     * - choice: directedCallParkId | directedCallParkDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta information extracted from the WSDL
     * - choice: directedCallParkId | directedCallParkDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * Constructor method for LBLFDirectedCallPark
     * @uses LBLFDirectedCallPark::setLabel()
     * @uses LBLFDirectedCallPark::setDirectedCallParkId()
     * @uses LBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @uses LBLFDirectedCallPark::setIndex()
     * @param string $label
     * @param string $directedCallParkId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @param string $index
     */
    public function __construct($label = null, $directedCallParkId = null, \\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null, $index = null)
    {
        $this
            ->setLabel($label)
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition)
            ->setIndex($index);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LBLFDirectedCallPark
     */
    public function setLabel($label = null)
    {
        $this->label = $label;
        return $this;
    }
    /**
     * Get directedCallParkId value
     * @return string|null
     */
    public function getDirectedCallParkId()
    {
        return isset($this->directedCallParkId) ? $this->directedCallParkId : null;
    }
    /**
     * Set directedCallParkId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $directedCallParkId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        if (is_null($directedCallParkId) || (is_array($directedCallParkId) && empty($directedCallParkId))) {
            unset($this->directedCallParkId);
        } else {
            $this->directedCallParkId = $directedCallParkId;
        }
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition|null
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return isset($this->directedCallParkDnAndPartition) ? $this->directedCallParkDnAndPartition : null;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(\\Losc\CucmBundle\Model\Webservice\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        if (is_null($directedCallParkDnAndPartition) || (is_array($directedCallParkDnAndPartition) && empty($directedCallParkDnAndPartition))) {
            unset($this->directedCallParkDnAndPartition);
        } else {
            $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        }
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LBLFDirectedCallPark
     */
    public function setIndex($index = null)
    {
        $this->index = $index;
        return $this;
    }
}
