<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTvsCertificateReq StructType
 * @subpackage Structs
 */
class GetTvsCertificateReq extends AbstractStructBase
{
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serialNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RTvsCertificate
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetTvsCertificateReq
     * @uses GetTvsCertificateReq::setIssuerName()
     * @uses GetTvsCertificateReq::setSerialNumber()
     * @uses GetTvsCertificateReq::setUuid()
     * @uses GetTvsCertificateReq::setReturnedTags()
     * @uses GetTvsCertificateReq::setSequence()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $uuid
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RTvsCertificate $returnedTags
     * @param int $sequence
     */
    public function __construct($issuerName = null, $serialNumber = null, $uuid = null, \\Losc\CucmBundle\Model\Webservice\StructType\RTvsCertificate $returnedTags = null, $sequence = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get issuerName value
     * @return string
     */
    public function getIssuerName()
    {
        return isset($this->issuerName) ? $this->issuerName : null;
    }
    /**
     * Set issuerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $issuerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq
     */
    public function setIssuerName($issuerName = null)
    {
        if (is_null($issuerName) || (is_array($issuerName) && empty($issuerName))) {
            unset($this->issuerName);
        } else {
            $this->issuerName = $issuerName;
        }
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string
     */
    public function getSerialNumber()
    {
        return isset($this->serialNumber) ? $this->serialNumber : null;
    }
    /**
     * Set serialNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $serialNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq
     */
    public function setSerialNumber($serialNumber = null)
    {
        if (is_null($serialNumber) || (is_array($serialNumber) && empty($serialNumber))) {
            unset($this->serialNumber);
        } else {
            $this->serialNumber = $serialNumber;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RTvsCertificate|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RTvsCertificate $returnedTags
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq
     */
    public function setReturnedTags(\\Losc\CucmBundle\Model\Webservice\StructType\RTvsCertificate $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetTvsCertificateReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
