<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRoutePatternReq StructType
 * @subpackage Structs
 */
class GetRoutePatternReq extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - documentation: dialPlan is mandatory for patterns with @ in it.
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern | routePartitionName | dialPlanName | routeFilterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetRoutePatternReq
     * @uses GetRoutePatternReq::setPattern()
     * @uses GetRoutePatternReq::setRoutePartitionName()
     * @uses GetRoutePatternReq::setDialPlanName()
     * @uses GetRoutePatternReq::setRouteFilterName()
     * @uses GetRoutePatternReq::setUuid()
     * @uses GetRoutePatternReq::setReturnedTags()
     * @uses GetRoutePatternReq::setSequence()
     * @param string $pattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $uuid
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern $returnedTags
     * @param int $sequence
     */
    public function __construct($pattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $uuid = null, \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern $returnedTags = null, $sequence = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDialPlanName($dialPlanName)
            ->setRouteFilterName($routeFilterName)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * Set dialPlanName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setDialPlanName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * Set routeFilterName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setRouteFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get returnedTags value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern $returnedTags
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setReturnedTags(\\Losc\CucmBundle\Model\Webservice\StructType\RRoutePattern $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetRoutePatternReq
     */
    public function setSequence($sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
}
