<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLdapSyncStatusReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Cancels the sync which is currently under process.
 * @subpackage Structs
 */
class GetLdapSyncStatusReq extends APIRequest
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The config name of the Ldap Directory.
     * - choice: name | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: name | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for GetLdapSyncStatusReq
     * @uses GetLdapSyncStatusReq::setName()
     * @uses GetLdapSyncStatusReq::setUuid()
     * @param string $name
     * @param string $uuid
     */
    public function __construct($name = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncStatusReq
     */
    public function setName($name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GetLdapSyncStatusReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
}
