<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoLdapSyncReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Initiates the sync
 * @subpackage Structs
 */
class DoLdapSyncReq extends APIRequest
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The Config Name of the Ldap Directory.
     * - choice: name | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: name | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sync
     * Meta information extracted from the WSDL
     * - documentation: True means start sync, false means cancel the sync which is currently under process
     * - base: xsd:string
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sync;
    /**
     * Constructor method for DoLdapSyncReq
     * @uses DoLdapSyncReq::setName()
     * @uses DoLdapSyncReq::setUuid()
     * @uses DoLdapSyncReq::setSync()
     * @param string $name
     * @param string $uuid
     * @param string $sync
     */
    public function __construct($name = null, $uuid = null, $sync = null)
    {
        $this
            ->setName($name)
            ->setUuid($uuid)
            ->setSync($sync);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoLdapSyncReq
     */
    public function setName($name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoLdapSyncReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get sync value
     * @return string|null
     */
    public function getSync()
    {
        return $this->sync;
    }
    /**
     * Set sync value
     * @param string $sync
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoLdapSyncReq
     */
    public function setSync($sync = null)
    {
        $this->sync = $sync;
        return $this;
    }
}
