<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoDeviceResetReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Performs either a hard or soft reset on the specified device. If resetting an MGCP box, then set isMGCP attribute to true.
 * @subpackage Structs
 */
class DoDeviceResetReq extends APIRequest
{
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - documentation: The name or UUID of the device to performs a reset on. Not nullable.
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $deviceName;
    /**
     * The isHardReset
     * Meta information extracted from the WSDL
     * - documentation: True performs a hard reset. False performs a soft reset. Not nullable.
     * - base: xsd:string
     * - choice: isHardReset | deviceResetType
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isHardReset;
    /**
     * The deviceResetType
     * Meta information extracted from the WSDL
     * - documentation: Not nullable
     * - choice: isHardReset | deviceResetType
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - nillable: false
     * @var string
     */
    public $deviceResetType;
    /**
     * The isMGCP
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * - use: optional
     * @var string
     */
    public $isMGCP;
    /**
     * Constructor method for DoDeviceResetReq
     * @uses DoDeviceResetReq::setDeviceName()
     * @uses DoDeviceResetReq::setIsHardReset()
     * @uses DoDeviceResetReq::setDeviceResetType()
     * @uses DoDeviceResetReq::setIsMGCP()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @param string $isHardReset
     * @param string $deviceResetType
     * @param string $isMGCP
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null, $isHardReset = null, $deviceResetType = null, $isMGCP = 'false')
    {
        $this
            ->setDeviceName($deviceName)
            ->setIsHardReset($isHardReset)
            ->setDeviceResetType($deviceResetType)
            ->setIsMGCP($isMGCP);
    }
    /**
     * Get deviceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setDeviceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get isHardReset value
     * @return string|null
     */
    public function getIsHardReset()
    {
        return isset($this->isHardReset) ? $this->isHardReset : null;
    }
    /**
     * Set isHardReset value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $isHardReset
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setIsHardReset($isHardReset = null)
    {
        if (is_null($isHardReset) || (is_array($isHardReset) && empty($isHardReset))) {
            unset($this->isHardReset);
        } else {
            $this->isHardReset = $isHardReset;
        }
        return $this;
    }
    /**
     * Get deviceResetType value
     * @return string|null
     */
    public function getDeviceResetType()
    {
        return isset($this->deviceResetType) ? $this->deviceResetType : null;
    }
    /**
     * Set deviceResetType value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $deviceResetType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setDeviceResetType($deviceResetType = null)
    {
        if (is_null($deviceResetType) || (is_array($deviceResetType) && empty($deviceResetType))) {
            unset($this->deviceResetType);
        } else {
            $this->deviceResetType = $deviceResetType;
        }
        return $this;
    }
    /**
     * Get isMGCP value
     * @return string|null
     */
    public function getIsMGCP()
    {
        return $this->isMGCP;
    }
    /**
     * Set isMGCP value
     * @param string $isMGCP
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceResetReq
     */
    public function setIsMGCP($isMGCP = 'false')
    {
        $this->isMGCP = $isMGCP;
        return $this;
    }
}
