<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoAuthenticateUserReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Authenticates the user on the basis of pin or password.
 * @subpackage Structs
 */
class DoAuthenticateUserReq extends APIRequest
{
    /**
     * The userid
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - choice: password | pin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - documentation: Applicable for end users only.
     * - base: xsd:string
     * - choice: password | pin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \d\d\d\d+
     * @var string
     */
    public $pin;
    /**
     * Constructor method for DoAuthenticateUserReq
     * @uses DoAuthenticateUserReq::setUserid()
     * @uses DoAuthenticateUserReq::setPassword()
     * @uses DoAuthenticateUserReq::setPin()
     * @param string $userid
     * @param string $password
     * @param string $pin
     */
    public function __construct($userid = null, $password = null, $pin = null)
    {
        $this
            ->setUserid($userid)
            ->setPassword($password)
            ->setPin($pin);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoAuthenticateUserReq
     */
    public function setUserid($userid = null)
    {
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoAuthenticateUserReq
     */
    public function setPassword($password = null)
    {
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return isset($this->pin) ? $this->pin : null;
    }
    /**
     * Set pin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pin
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoAuthenticateUserReq
     */
    public function setPin($pin = null)
    {
        if (is_null($pin) || (is_array($pin) && empty($pin))) {
            unset($this->pin);
        } else {
            $this->pin = $pin;
        }
        return $this;
    }
}
