<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attributeSet StructType
 * @subpackage Structs
 */
class AttributeSet extends XCommonMembersExtension
{
    /**
     * The attributeNameString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $attributeNameString;
    /**
     * The sdpAttributeHandling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sdpAttributeHandling;
    /**
     * The allowedValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $allowedValue;
    /**
     * Constructor method for attributeSet
     * @uses AttributeSet::setAttributeNameString()
     * @uses AttributeSet::setSdpAttributeHandling()
     * @uses AttributeSet::setAllowedValue()
     * @param string $attributeNameString
     * @param string $sdpAttributeHandling
     * @param string[] $allowedValue
     */
    public function __construct($attributeNameString = null, $sdpAttributeHandling = null, array $allowedValue = array())
    {
        $this
            ->setAttributeNameString($attributeNameString)
            ->setSdpAttributeHandling($sdpAttributeHandling)
            ->setAllowedValue($allowedValue);
    }
    /**
     * Get attributeNameString value
     * @return string|null
     */
    public function getAttributeNameString()
    {
        return $this->attributeNameString;
    }
    /**
     * Set attributeNameString value
     * @param string $attributeNameString
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AttributeSet
     */
    public function setAttributeNameString($attributeNameString = null)
    {
        $this->attributeNameString = $attributeNameString;
        return $this;
    }
    /**
     * Get sdpAttributeHandling value
     * @return string|null
     */
    public function getSdpAttributeHandling()
    {
        return $this->sdpAttributeHandling;
    }
    /**
     * Set sdpAttributeHandling value
     * @param string $sdpAttributeHandling
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AttributeSet
     */
    public function setSdpAttributeHandling($sdpAttributeHandling = null)
    {
        $this->sdpAttributeHandling = $sdpAttributeHandling;
        return $this;
    }
    /**
     * Get allowedValue value
     * @return string[]|null
     */
    public function getAllowedValue()
    {
        return $this->allowedValue;
    }
    /**
     * Set allowedValue value
     * @param string[] $allowedValue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AttributeSet
     */
    public function setAllowedValue(array $allowedValue = array())
    {
        $this->allowedValue = $allowedValue;
        return $this;
    }
    /**
     * Add item to allowedValue value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AttributeSet
     */
    public function addToAllowedValue($item)
    {
        $this->allowedValue[] = $item;
        return $this;
    }
}
