<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XTransport EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XTransport extends AbstractStructEnumBase
{
    /**
     * Constant for value 'TCP'
     * @return string 'TCP'
     */
    const VALUE_TCP = 'TCP';
    /**
     * Constant for value 'UDP'
     * @return string 'UDP'
     */
    const VALUE_UDP = 'UDP';
    /**
     * Constant for value 'TLS'
     * @return string 'TLS'
     */
    const VALUE_TLS = 'TLS';
    /**
     * Constant for value 'TCP+UDP'
     * @return string 'TCP+UDP'
     */
    const VALUE_TCP_UDP = 'TCP+UDP';
    /**
     * Return allowed values
     * @uses self::VALUE_TCP
     * @uses self::VALUE_UDP
     * @uses self::VALUE_TLS
     * @uses self::VALUE_TCP_UDP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TCP,
            self::VALUE_UDP,
            self::VALUE_TLS,
            self::VALUE_TCP_UDP,
        );
    }
}
