<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XLossyNetwork EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XLossyNetwork extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Keep Current Setting'
     * @return string 'Keep Current Setting'
     */
    const VALUE_KEEP_CURRENT_SETTING = 'Keep Current Setting';
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Constant for value 'Low Loss'
     * @return string 'Low Loss'
     */
    const VALUE_LOW_LOSS = 'Low Loss';
    /**
     * Constant for value 'Lossy'
     * @return string 'Lossy'
     */
    const VALUE_LOSSY = 'Lossy';
    /**
     * Return allowed values
     * @uses self::VALUE_KEEP_CURRENT_SETTING
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @uses self::VALUE_LOW_LOSS
     * @uses self::VALUE_LOSSY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEEP_CURRENT_SETTING,
            self::VALUE_USE_SYSTEM_DEFAULT,
            self::VALUE_LOW_LOSS,
            self::VALUE_LOSSY,
        );
    }
}
