<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVohServer StructType
 * @subpackage Structs
 */
class XVohServer extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - documentation: SIP Trunk for Video On Hold Server
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The defaultVideoStreamId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $defaultVideoStreamId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XVohServer
     * @uses XVohServer::setName()
     * @uses XVohServer::setSipTrunkName()
     * @uses XVohServer::setDefaultVideoStreamId()
     * @uses XVohServer::setDescription()
     * @param string $name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param string $defaultVideoStreamId
     * @param string $description
     */
    public function __construct($name = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, $defaultVideoStreamId = null, $description = null)
    {
        $this
            ->setName($name)
            ->setSipTrunkName($sipTrunkName)
            ->setDefaultVideoStreamId($defaultVideoStreamId)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVohServer
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVohServer
     */
    public function setSipTrunkName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get defaultVideoStreamId value
     * @return string
     */
    public function getDefaultVideoStreamId()
    {
        return $this->defaultVideoStreamId;
    }
    /**
     * Set defaultVideoStreamId value
     * @param string $defaultVideoStreamId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVohServer
     */
    public function setDefaultVideoStreamId($defaultVideoStreamId = null)
    {
        $this->defaultVideoStreamId = $defaultVideoStreamId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVohServer
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
}
