<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUser StructType
 * @subpackage Structs
 */
class XUser extends AbstractStructBase
{
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lastName;
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $firstName;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $middleName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The mailid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mailid;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $department;
    /**
     * The manager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $manager;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The primaryExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension
     */
    public $primaryExtension;
    /**
     * The associatedPc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $associatedPc;
    /**
     * The associatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The enableCti
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCti;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $digestCredentials;
    /**
     * The phoneProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles
     */
    public $phoneProfiles;
    /**
     * The defaultProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultProfile;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The enableMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobility;
    /**
     * The enableMobileVoiceAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileVoiceAccess;
    /**
     * The maxDeskPickupWaitTime
     * Meta information extracted from the WSDL
     * - documentation: Maximum wait time for Desk Pickup must be a number in the range 0 to 30000.Not Nullable.
     * - default: 10000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxDeskPickupWaitTime;
    /**
     * The remoteDestinationLimit
     * Meta information extracted from the WSDL
     * - documentation: Remote Destination Limit must be a number in the range 1 to 10. Not Nullable.
     * - default: 4
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $remoteDestinationLimit;
    /**
     * The passwordCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The pinCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials
     */
    public $pinCredentials;
    /**
     * The primaryDevice
     * Meta information extracted from the WSDL
     * - documentation: Primary Device for mobility users
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryDevice;
    /**
     * The enableEmcc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableEmcc;
    /**
     * The ctiControlledDeviceProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The numericUserId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numericUserId;
    /**
     * The mlppPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppPassword;
    /**
     * The customUserFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields
     */
    public $customUserFields;
    /**
     * The homeCluster
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $homeCluster;
    /**
     * The imAndPresenceEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $imAndPresenceEnable;
    /**
     * The serviceProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $serviceProfile;
    /**
     * The lineAppearanceAssociationForPresences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences
     */
    public $lineAppearanceAssociationForPresences;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $directoryUri;
    /**
     * The telephoneNumber
     * Meta information extracted from the WSDL
     * - documentation: This field also corresponds to the field 'Number Displayed in Directory' for the Quick User/phone Add page.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $telephoneNumber;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $title;
    /**
     * The mobileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mobileNumber;
    /**
     * The homeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $homeNumber;
    /**
     * The pagerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pagerNumber;
    /**
     * The extensionsInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo
     */
    public $extensionsInfo;
    /**
     * The selfService
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $selfService;
    /**
     * The userProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $userProfile;
    /**
     * The calendarPresence
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $calendarPresence;
    /**
     * The ldapDirectoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ldapDirectoryName;
    /**
     * The userIdentity
     * Meta information extracted from the WSDL
     * - documentation: Value should be of of the format user@domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userIdentity;
    /**
     * The nameDialing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nameDialing;
    /**
     * The ipccExtension
     * Meta information extracted from the WSDL
     * - documentation: Applicable for Controlled Devices so this tag is appropriate for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ipccExtension;
    /**
     * The convertUserAccount
     * Meta information extracted from the WSDL
     * - documentation: These tags are for Get/UpdateUser APIs only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $convertUserAccount;
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies this is a Locally created user and a value of 'LDAP' implies this user is an LDAP Synchronized user
     * - default: Local
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountType;
    /**
     * The authenticationType
     * Meta information extracted from the WSDL
     * - documentation: Valid values are 'Local' or 'LDAP'. Value of 'Local' implies authentication will happen at CUCM and a value of 'LDAP' implies authentication will happen at the LDAP
     * - default: Local
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationType;
    /**
     * Constructor method for XUser
     * @uses XUser::setLastName()
     * @uses XUser::setUserid()
     * @uses XUser::setPresenceGroupName()
     * @uses XUser::setFirstName()
     * @uses XUser::setMiddleName()
     * @uses XUser::setPassword()
     * @uses XUser::setPin()
     * @uses XUser::setMailid()
     * @uses XUser::setDepartment()
     * @uses XUser::setManager()
     * @uses XUser::setUserLocale()
     * @uses XUser::setAssociatedDevices()
     * @uses XUser::setPrimaryExtension()
     * @uses XUser::setAssociatedPc()
     * @uses XUser::setAssociatedGroups()
     * @uses XUser::setEnableCti()
     * @uses XUser::setDigestCredentials()
     * @uses XUser::setPhoneProfiles()
     * @uses XUser::setDefaultProfile()
     * @uses XUser::setSubscribeCallingSearchSpaceName()
     * @uses XUser::setEnableMobility()
     * @uses XUser::setEnableMobileVoiceAccess()
     * @uses XUser::setMaxDeskPickupWaitTime()
     * @uses XUser::setRemoteDestinationLimit()
     * @uses XUser::setPasswordCredentials()
     * @uses XUser::setPinCredentials()
     * @uses XUser::setPrimaryDevice()
     * @uses XUser::setEnableEmcc()
     * @uses XUser::setCtiControlledDeviceProfiles()
     * @uses XUser::setPatternPrecedence()
     * @uses XUser::setNumericUserId()
     * @uses XUser::setMlppPassword()
     * @uses XUser::setCustomUserFields()
     * @uses XUser::setHomeCluster()
     * @uses XUser::setImAndPresenceEnable()
     * @uses XUser::setServiceProfile()
     * @uses XUser::setLineAppearanceAssociationForPresences()
     * @uses XUser::setDirectoryUri()
     * @uses XUser::setTelephoneNumber()
     * @uses XUser::setTitle()
     * @uses XUser::setMobileNumber()
     * @uses XUser::setHomeNumber()
     * @uses XUser::setPagerNumber()
     * @uses XUser::setExtensionsInfo()
     * @uses XUser::setSelfService()
     * @uses XUser::setUserProfile()
     * @uses XUser::setCalendarPresence()
     * @uses XUser::setLdapDirectoryName()
     * @uses XUser::setUserIdentity()
     * @uses XUser::setNameDialing()
     * @uses XUser::setIpccExtension()
     * @uses XUser::setConvertUserAccount()
     * @uses XUser::setAccountType()
     * @uses XUser::setAuthenticationType()
     * @param string $lastName
     * @param string $userid
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $firstName
     * @param string $middleName
     * @param string $password
     * @param string $pin
     * @param string $mailid
     * @param string $department
     * @param string $manager
     * @param string $userLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension
     * @param string $associatedPc
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @param string $enableCti
     * @param string $digestCredentials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $enableMobility
     * @param string $enableMobileVoiceAccess
     * @param string $maxDeskPickupWaitTime
     * @param string $remoteDestinationLimit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice
     * @param string $enableEmcc
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $patternPrecedence
     * @param string $numericUserId
     * @param string $mlppPassword
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields
     * @param string $homeCluster
     * @param string $imAndPresenceEnable
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @param string $directoryUri
     * @param string $telephoneNumber
     * @param string $title
     * @param string $mobileNumber
     * @param string $homeNumber
     * @param string $pagerNumber
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo
     * @param string $selfService
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @param string $calendarPresence
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName
     * @param string $userIdentity
     * @param string $nameDialing
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount
     * @param string $accountType
     * @param string $authenticationType
     */
    public function __construct($lastName = null, $userid = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $firstName = null, $middleName = null, $password = null, $pin = null, $mailid = null, $department = null, $manager = null, $userLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension = null, $associatedPc = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null, $enableCti = 'true', $digestCredentials = null, \\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, $enableMobility = 'false', $enableMobileVoiceAccess = 'false', $maxDeskPickupWaitTime = '10000', $remoteDestinationLimit = '4', \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null, \\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice = null, $enableEmcc = null, \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $patternPrecedence = 'Default', $numericUserId = null, $mlppPassword = null, \\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields = null, $homeCluster = 'true', $imAndPresenceEnable = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null, $directoryUri = null, $telephoneNumber = null, $title = null, $mobileNumber = null, $homeNumber = null, $pagerNumber = null, \\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo = null, $selfService = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null, $calendarPresence = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName = null, $userIdentity = null, $nameDialing = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount = null, $accountType = 'Local', $authenticationType = 'Local')
    {
        $this
            ->setLastName($lastName)
            ->setUserid($userid)
            ->setPresenceGroupName($presenceGroupName)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setPassword($password)
            ->setPin($pin)
            ->setMailid($mailid)
            ->setDepartment($department)
            ->setManager($manager)
            ->setUserLocale($userLocale)
            ->setAssociatedDevices($associatedDevices)
            ->setPrimaryExtension($primaryExtension)
            ->setAssociatedPc($associatedPc)
            ->setAssociatedGroups($associatedGroups)
            ->setEnableCti($enableCti)
            ->setDigestCredentials($digestCredentials)
            ->setPhoneProfiles($phoneProfiles)
            ->setDefaultProfile($defaultProfile)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setEnableMobility($enableMobility)
            ->setEnableMobileVoiceAccess($enableMobileVoiceAccess)
            ->setMaxDeskPickupWaitTime($maxDeskPickupWaitTime)
            ->setRemoteDestinationLimit($remoteDestinationLimit)
            ->setPasswordCredentials($passwordCredentials)
            ->setPinCredentials($pinCredentials)
            ->setPrimaryDevice($primaryDevice)
            ->setEnableEmcc($enableEmcc)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setPatternPrecedence($patternPrecedence)
            ->setNumericUserId($numericUserId)
            ->setMlppPassword($mlppPassword)
            ->setCustomUserFields($customUserFields)
            ->setHomeCluster($homeCluster)
            ->setImAndPresenceEnable($imAndPresenceEnable)
            ->setServiceProfile($serviceProfile)
            ->setLineAppearanceAssociationForPresences($lineAppearanceAssociationForPresences)
            ->setDirectoryUri($directoryUri)
            ->setTelephoneNumber($telephoneNumber)
            ->setTitle($title)
            ->setMobileNumber($mobileNumber)
            ->setHomeNumber($homeNumber)
            ->setPagerNumber($pagerNumber)
            ->setExtensionsInfo($extensionsInfo)
            ->setSelfService($selfService)
            ->setUserProfile($userProfile)
            ->setCalendarPresence($calendarPresence)
            ->setLdapDirectoryName($ldapDirectoryName)
            ->setUserIdentity($userIdentity)
            ->setNameDialing($nameDialing)
            ->setIpccExtension($ipccExtension)
            ->setConvertUserAccount($convertUserAccount)
            ->setAccountType($accountType)
            ->setAuthenticationType($authenticationType);
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setLastName($lastName = null)
    {
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setUserid($userid = null)
    {
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setFirstName($firstName = null)
    {
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setMiddleName($middleName = null)
    {
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPin($pin = null)
    {
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get mailid value
     * @return string|null
     */
    public function getMailid()
    {
        return $this->mailid;
    }
    /**
     * Set mailid value
     * @param string $mailid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setMailid($mailid = null)
    {
        $this->mailid = $mailid;
        return $this;
    }
    /**
     * Get department value
     * @return string|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setDepartment($department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setManager($manager = null)
    {
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setAssociatedDevices(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get primaryExtension value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension|null
     */
    public function getPrimaryExtension()
    {
        return $this->primaryExtension;
    }
    /**
     * Set primaryExtension value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPrimaryExtension(\\Losc\CucmBundle\Model\Webservice\StructType\PrimaryExtension $primaryExtension = null)
    {
        $this->primaryExtension = $primaryExtension;
        return $this;
    }
    /**
     * Get associatedPc value
     * @return string|null
     */
    public function getAssociatedPc()
    {
        return $this->associatedPc;
    }
    /**
     * Set associatedPc value
     * @param string $associatedPc
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setAssociatedPc($associatedPc = null)
    {
        $this->associatedPc = $associatedPc;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setAssociatedGroups(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get enableCti value
     * @return string|null
     */
    public function getEnableCti()
    {
        return $this->enableCti;
    }
    /**
     * Set enableCti value
     * @param string $enableCti
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setEnableCti($enableCti = 'true')
    {
        $this->enableCti = $enableCti;
        return $this;
    }
    /**
     * Get digestCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return isset($this->digestCredentials) ? $this->digestCredentials : null;
    }
    /**
     * Set digestCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $digestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        if (is_null($digestCredentials) || (is_array($digestCredentials) && empty($digestCredentials))) {
            unset($this->digestCredentials);
        } else {
            $this->digestCredentials = $digestCredentials;
        }
        return $this;
    }
    /**
     * Get phoneProfiles value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles|null
     */
    public function getPhoneProfiles()
    {
        return $this->phoneProfiles;
    }
    /**
     * Set phoneProfiles value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPhoneProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\PhoneProfiles $phoneProfiles = null)
    {
        $this->phoneProfiles = $phoneProfiles;
        return $this;
    }
    /**
     * Get defaultProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultProfile()
    {
        return $this->defaultProfile;
    }
    /**
     * Set defaultProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setDefaultProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfile = null)
    {
        $this->defaultProfile = $defaultProfile;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setSubscribeCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get enableMobility value
     * @return string|null
     */
    public function getEnableMobility()
    {
        return $this->enableMobility;
    }
    /**
     * Set enableMobility value
     * @param string $enableMobility
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setEnableMobility($enableMobility = 'false')
    {
        $this->enableMobility = $enableMobility;
        return $this;
    }
    /**
     * Get enableMobileVoiceAccess value
     * @return string|null
     */
    public function getEnableMobileVoiceAccess()
    {
        return $this->enableMobileVoiceAccess;
    }
    /**
     * Set enableMobileVoiceAccess value
     * @param string $enableMobileVoiceAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setEnableMobileVoiceAccess($enableMobileVoiceAccess = 'false')
    {
        $this->enableMobileVoiceAccess = $enableMobileVoiceAccess;
        return $this;
    }
    /**
     * Get maxDeskPickupWaitTime value
     * @return string|null
     */
    public function getMaxDeskPickupWaitTime()
    {
        return $this->maxDeskPickupWaitTime;
    }
    /**
     * Set maxDeskPickupWaitTime value
     * @param string $maxDeskPickupWaitTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setMaxDeskPickupWaitTime($maxDeskPickupWaitTime = '10000')
    {
        $this->maxDeskPickupWaitTime = $maxDeskPickupWaitTime;
        return $this;
    }
    /**
     * Get remoteDestinationLimit value
     * @return string|null
     */
    public function getRemoteDestinationLimit()
    {
        return $this->remoteDestinationLimit;
    }
    /**
     * Set remoteDestinationLimit value
     * @param string $remoteDestinationLimit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setRemoteDestinationLimit($remoteDestinationLimit = '4')
    {
        $this->remoteDestinationLimit = $remoteDestinationLimit;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPasswordCredentials(\\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get pinCredentials value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials|null
     */
    public function getPinCredentials()
    {
        return $this->pinCredentials;
    }
    /**
     * Set pinCredentials value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPinCredentials(\\Losc\CucmBundle\Model\Webservice\StructType\PinCredentials $pinCredentials = null)
    {
        $this->pinCredentials = $pinCredentials;
        return $this;
    }
    /**
     * Get primaryDevice value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryDevice()
    {
        return $this->primaryDevice;
    }
    /**
     * Set primaryDevice value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPrimaryDevice(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryDevice = null)
    {
        $this->primaryDevice = $primaryDevice;
        return $this;
    }
    /**
     * Get enableEmcc value
     * @return string|null
     */
    public function getEnableEmcc()
    {
        return $this->enableEmcc;
    }
    /**
     * Set enableEmcc value
     * @param string $enableEmcc
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setEnableEmcc($enableEmcc = null)
    {
        $this->enableEmcc = $enableEmcc;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setCtiControlledDeviceProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param string $patternPrecedence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get numericUserId value
     * @return string|null
     */
    public function getNumericUserId()
    {
        return $this->numericUserId;
    }
    /**
     * Set numericUserId value
     * @param string $numericUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setNumericUserId($numericUserId = null)
    {
        $this->numericUserId = $numericUserId;
        return $this;
    }
    /**
     * Get mlppPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppPassword()
    {
        return isset($this->mlppPassword) ? $this->mlppPassword : null;
    }
    /**
     * Set mlppPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppPassword
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setMlppPassword($mlppPassword = null)
    {
        if (is_null($mlppPassword) || (is_array($mlppPassword) && empty($mlppPassword))) {
            unset($this->mlppPassword);
        } else {
            $this->mlppPassword = $mlppPassword;
        }
        return $this;
    }
    /**
     * Get customUserFields value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields|null
     */
    public function getCustomUserFields()
    {
        return $this->customUserFields;
    }
    /**
     * Set customUserFields value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setCustomUserFields(\\Losc\CucmBundle\Model\Webservice\StructType\CustomUserFields $customUserFields = null)
    {
        $this->customUserFields = $customUserFields;
        return $this;
    }
    /**
     * Get homeCluster value
     * @return string|null
     */
    public function getHomeCluster()
    {
        return $this->homeCluster;
    }
    /**
     * Set homeCluster value
     * @param string $homeCluster
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setHomeCluster($homeCluster = 'true')
    {
        $this->homeCluster = $homeCluster;
        return $this;
    }
    /**
     * Get imAndPresenceEnable value
     * @return string|null
     */
    public function getImAndPresenceEnable()
    {
        return $this->imAndPresenceEnable;
    }
    /**
     * Set imAndPresenceEnable value
     * @param string $imAndPresenceEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setImAndPresenceEnable($imAndPresenceEnable = null)
    {
        $this->imAndPresenceEnable = $imAndPresenceEnable;
        return $this;
    }
    /**
     * Get serviceProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getServiceProfile()
    {
        return isset($this->serviceProfile) ? $this->serviceProfile : null;
    }
    /**
     * Set serviceProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setServiceProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $serviceProfile = null)
    {
        if (is_null($serviceProfile) || (is_array($serviceProfile) && empty($serviceProfile))) {
            unset($this->serviceProfile);
        } else {
            $this->serviceProfile = $serviceProfile;
        }
        return $this;
    }
    /**
     * Get lineAppearanceAssociationForPresences value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences|null
     */
    public function getLineAppearanceAssociationForPresences()
    {
        return $this->lineAppearanceAssociationForPresences;
    }
    /**
     * Set lineAppearanceAssociationForPresences value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setLineAppearanceAssociationForPresences(\\Losc\CucmBundle\Model\Webservice\StructType\LineAppearanceAssociationForPresences $lineAppearanceAssociationForPresences = null)
    {
        $this->lineAppearanceAssociationForPresences = $lineAppearanceAssociationForPresences;
        return $this;
    }
    /**
     * Get directoryUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return isset($this->directoryUri) ? $this->directoryUri : null;
    }
    /**
     * Set directoryUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directoryUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setDirectoryUri($directoryUri = null)
    {
        if (is_null($directoryUri) || (is_array($directoryUri) && empty($directoryUri))) {
            unset($this->directoryUri);
        } else {
            $this->directoryUri = $directoryUri;
        }
        return $this;
    }
    /**
     * Get telephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->telephoneNumber;
    }
    /**
     * Set telephoneNumber value
     * @param string $telephoneNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        $this->telephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setTitle($title = null)
    {
        $this->title = $title;
        return $this;
    }
    /**
     * Get mobileNumber value
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->mobileNumber;
    }
    /**
     * Set mobileNumber value
     * @param string $mobileNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setMobileNumber($mobileNumber = null)
    {
        $this->mobileNumber = $mobileNumber;
        return $this;
    }
    /**
     * Get homeNumber value
     * @return string|null
     */
    public function getHomeNumber()
    {
        return $this->homeNumber;
    }
    /**
     * Set homeNumber value
     * @param string $homeNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setHomeNumber($homeNumber = null)
    {
        $this->homeNumber = $homeNumber;
        return $this;
    }
    /**
     * Get pagerNumber value
     * @return string|null
     */
    public function getPagerNumber()
    {
        return $this->pagerNumber;
    }
    /**
     * Set pagerNumber value
     * @param string $pagerNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setPagerNumber($pagerNumber = null)
    {
        $this->pagerNumber = $pagerNumber;
        return $this;
    }
    /**
     * Get extensionsInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo|null
     */
    public function getExtensionsInfo()
    {
        return $this->extensionsInfo;
    }
    /**
     * Set extensionsInfo value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setExtensionsInfo(\\Losc\CucmBundle\Model\Webservice\StructType\ExtensionsInfo $extensionsInfo = null)
    {
        $this->extensionsInfo = $extensionsInfo;
        return $this;
    }
    /**
     * Get selfService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelfService()
    {
        return isset($this->selfService) ? $this->selfService : null;
    }
    /**
     * Set selfService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selfService
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setSelfService($selfService = null)
    {
        if (is_null($selfService) || (is_array($selfService) && empty($selfService))) {
            unset($this->selfService);
        } else {
            $this->selfService = $selfService;
        }
        return $this;
    }
    /**
     * Get userProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUserProfile()
    {
        return isset($this->userProfile) ? $this->userProfile : null;
    }
    /**
     * Set userProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setUserProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $userProfile = null)
    {
        if (is_null($userProfile) || (is_array($userProfile) && empty($userProfile))) {
            unset($this->userProfile);
        } else {
            $this->userProfile = $userProfile;
        }
        return $this;
    }
    /**
     * Get calendarPresence value
     * @return string|null
     */
    public function getCalendarPresence()
    {
        return $this->calendarPresence;
    }
    /**
     * Set calendarPresence value
     * @param string $calendarPresence
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setCalendarPresence($calendarPresence = 'false')
    {
        $this->calendarPresence = $calendarPresence;
        return $this;
    }
    /**
     * Get ldapDirectoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLdapDirectoryName()
    {
        return isset($this->ldapDirectoryName) ? $this->ldapDirectoryName : null;
    }
    /**
     * Set ldapDirectoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setLdapDirectoryName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapDirectoryName = null)
    {
        if (is_null($ldapDirectoryName) || (is_array($ldapDirectoryName) && empty($ldapDirectoryName))) {
            unset($this->ldapDirectoryName);
        } else {
            $this->ldapDirectoryName = $ldapDirectoryName;
        }
        return $this;
    }
    /**
     * Get userIdentity value
     * @return string|null
     */
    public function getUserIdentity()
    {
        return $this->userIdentity;
    }
    /**
     * Set userIdentity value
     * @param string $userIdentity
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setUserIdentity($userIdentity = null)
    {
        $this->userIdentity = $userIdentity;
        return $this;
    }
    /**
     * Get nameDialing value
     * @return string|null
     */
    public function getNameDialing()
    {
        return $this->nameDialing;
    }
    /**
     * Set nameDialing value
     * @param string $nameDialing
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setNameDialing($nameDialing = null)
    {
        $this->nameDialing = $nameDialing;
        return $this;
    }
    /**
     * Get ipccExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIpccExtension()
    {
        return isset($this->ipccExtension) ? $this->ipccExtension : null;
    }
    /**
     * Set ipccExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setIpccExtension(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ipccExtension = null)
    {
        if (is_null($ipccExtension) || (is_array($ipccExtension) && empty($ipccExtension))) {
            unset($this->ipccExtension);
        } else {
            $this->ipccExtension = $ipccExtension;
        }
        return $this;
    }
    /**
     * Get convertUserAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getConvertUserAccount()
    {
        return isset($this->convertUserAccount) ? $this->convertUserAccount : null;
    }
    /**
     * Set convertUserAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setConvertUserAccount(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $convertUserAccount = null)
    {
        if (is_null($convertUserAccount) || (is_array($convertUserAccount) && empty($convertUserAccount))) {
            unset($this->convertUserAccount);
        } else {
            $this->convertUserAccount = $convertUserAccount;
        }
        return $this;
    }
    /**
     * Get accountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @param string $accountType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setAccountType($accountType = 'Local')
    {
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get authenticationType value
     * @return string|null
     */
    public function getAuthenticationType()
    {
        return $this->authenticationType;
    }
    /**
     * Set authenticationType value
     * @param string $authenticationType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUser
     */
    public function setAuthenticationType($authenticationType = 'Local')
    {
        $this->authenticationType = $authenticationType;
        return $this;
    }
}
