<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUnitsToGateway StructType
 * @subpackage Structs
 */
class XUnitsToGateway extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - documentation: pkid of the Gateway
     * - base: xsd:string
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Units
     */
    public $units;
    /**
     * Constructor method for XUnitsToGateway
     * @uses XUnitsToGateway::setDomainName()
     * @uses XUnitsToGateway::setGatewayUuid()
     * @uses XUnitsToGateway::setUnits()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     */
    public function __construct($domainName = null, $gatewayUuid = null, \\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnits($units);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUnitsToGateway
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $gatewayUuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUnitsToGateway
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get units value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Units
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUnitsToGateway
     */
    public function setUnits(\\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
}
