<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUcService StructType
 * @subpackage Structs
 */
class XUcService extends AbstractStructBase
{
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The hostnameorip
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostnameorip;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence) and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $port;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for Unified CM (IM and Presence),CTI and AppStore ProductType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $protocol;
    /**
     * The ucServiceXml
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $ucServiceXml;
    /**
     * Constructor method for XUcService
     * @uses XUcService::setServiceType()
     * @uses XUcService::setProductType()
     * @uses XUcService::setName()
     * @uses XUcService::setHostnameorip()
     * @uses XUcService::setDescription()
     * @uses XUcService::setPort()
     * @uses XUcService::setProtocol()
     * @uses XUcService::setUcServiceXml()
     * @param string $serviceType
     * @param string $productType
     * @param string $name
     * @param string $hostnameorip
     * @param string $description
     * @param string $port
     * @param string $protocol
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml
     */
    public function __construct($serviceType = null, $productType = null, $name = null, $hostnameorip = null, $description = null, $port = null, $protocol = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setProductType($productType)
            ->setName($name)
            ->setHostnameorip($hostnameorip)
            ->setDescription($description)
            ->setPort($port)
            ->setProtocol($protocol)
            ->setUcServiceXml($ucServiceXml);
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setServiceType($serviceType = null)
    {
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get productType value
     * @return string
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get hostnameorip value
     * @return string
     */
    public function getHostnameorip()
    {
        return $this->hostnameorip;
    }
    /**
     * Set hostnameorip value
     * @param string $hostnameorip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setHostnameorip($hostnameorip = null)
    {
        $this->hostnameorip = $hostnameorip;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPort()
    {
        return isset($this->port) ? $this->port : null;
    }
    /**
     * Set port value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setPort($port = null)
    {
        if (is_null($port) || (is_array($port) && empty($port))) {
            unset($this->port);
        } else {
            $this->port = $port;
        }
        return $this;
    }
    /**
     * Get protocol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtocol()
    {
        return isset($this->protocol) ? $this->protocol : null;
    }
    /**
     * Set protocol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setProtocol($protocol = null)
    {
        if (is_null($protocol) || (is_array($protocol) && empty($protocol))) {
            unset($this->protocol);
        } else {
            $this->protocol = $protocol;
        }
        return $this;
    }
    /**
     * Get ucServiceXml value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getUcServiceXml()
    {
        return $this->ucServiceXml;
    }
    /**
     * Set ucServiceXml value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUcService
     */
    public function setUcServiceXml(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $ucServiceXml = null)
    {
        $this->ucServiceXml = $ucServiceXml;
        return $this;
    }
}
