<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTvsCertificate StructType
 * @subpackage Structs
 */
class XTvsCertificate extends AbstractStructBase
{
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serialNumber;
    /**
     * The subjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subjectName;
    /**
     * The timeToLive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $timeToLive;
    /**
     * The ipv4Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv4Address;
    /**
     * The ipv6Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv6Address;
    /**
     * The roles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Roles
     */
    public $roles;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Services
     */
    public $services;
    /**
     * Constructor method for XTvsCertificate
     * @uses XTvsCertificate::setIssuerName()
     * @uses XTvsCertificate::setSerialNumber()
     * @uses XTvsCertificate::setSubjectName()
     * @uses XTvsCertificate::setTimeToLive()
     * @uses XTvsCertificate::setIpv4Address()
     * @uses XTvsCertificate::setIpv6Address()
     * @uses XTvsCertificate::setRoles()
     * @uses XTvsCertificate::setServices()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $subjectName
     * @param int $timeToLive
     * @param string $ipv4Address
     * @param string $ipv6Address
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Roles $roles
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     */
    public function __construct($issuerName = null, $serialNumber = null, $subjectName = null, $timeToLive = null, $ipv4Address = null, $ipv6Address = null, \\Losc\CucmBundle\Model\Webservice\StructType\Roles $roles = null, \\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setSubjectName($subjectName)
            ->setTimeToLive($timeToLive)
            ->setIpv4Address($ipv4Address)
            ->setIpv6Address($ipv6Address)
            ->setRoles($roles)
            ->setServices($services);
    }
    /**
     * Get issuerName value
     * @return string
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setIssuerName($issuerName = null)
    {
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setSerialNumber($serialNumber = null)
    {
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get subjectName value
     * @return string|null
     */
    public function getSubjectName()
    {
        return $this->subjectName;
    }
    /**
     * Set subjectName value
     * @param string $subjectName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setSubjectName($subjectName = null)
    {
        $this->subjectName = $subjectName;
        return $this;
    }
    /**
     * Get timeToLive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimeToLive()
    {
        return isset($this->timeToLive) ? $this->timeToLive : null;
    }
    /**
     * Set timeToLive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setTimeToLive($timeToLive = null)
    {
        if (is_null($timeToLive) || (is_array($timeToLive) && empty($timeToLive))) {
            unset($this->timeToLive);
        } else {
            $this->timeToLive = $timeToLive;
        }
        return $this;
    }
    /**
     * Get ipv4Address value
     * @return string|null
     */
    public function getIpv4Address()
    {
        return $this->ipv4Address;
    }
    /**
     * Set ipv4Address value
     * @param string $ipv4Address
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setIpv4Address($ipv4Address = null)
    {
        $this->ipv4Address = $ipv4Address;
        return $this;
    }
    /**
     * Get ipv6Address value
     * @return string|null
     */
    public function getIpv6Address()
    {
        return $this->ipv6Address;
    }
    /**
     * Set ipv6Address value
     * @param string $ipv6Address
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setIpv6Address($ipv6Address = null)
    {
        $this->ipv6Address = $ipv6Address;
        return $this;
    }
    /**
     * Get roles value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Roles|null
     */
    public function getRoles()
    {
        return $this->roles;
    }
    /**
     * Set roles value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Roles $roles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setRoles(\\Losc\CucmBundle\Model\Webservice\StructType\Roles $roles = null)
    {
        $this->roles = $roles;
        return $this;
    }
    /**
     * Get services value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTvsCertificate
     */
    public function setServices(\\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
}
