<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTranscoder StructType
 * @subpackage Structs
 */
class XTranscoder extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Should not be modified for Cisco Media Termination Point (WS-SVC-CMM).
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the product.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The subUnit
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Media Termination Point (WS-SVC-CMM) and is a mandatory tag for Cisco Media Termination Point (WS-SVC-CMM) Transcoder. Valid values range from 1 to 4.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subUnit;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: This tag is used only by Cisco Media Termination Point (WS-SVC-CMM)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The isTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isTrustedRelayPoint;
    /**
     * The maximumCapacity
     * Meta information extracted from the WSDL
     * - documentation: This tag is mandatory only for Cisco Media Termination Point (WS-SVC-CMM). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maximumCapacity;
    /**
     * Constructor method for XTranscoder
     * @uses XTranscoder::setName()
     * @uses XTranscoder::setProduct()
     * @uses XTranscoder::setDevicePoolName()
     * @uses XTranscoder::setLoadInformation()
     * @uses XTranscoder::setDescription()
     * @uses XTranscoder::setSubUnit()
     * @uses XTranscoder::setCommonDeviceConfigName()
     * @uses XTranscoder::setVendorConfig()
     * @uses XTranscoder::setIsTrustedRelayPoint()
     * @uses XTranscoder::setMaximumCapacity()
     * @param string $name
     * @param string $product
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param string $description
     * @param string $subUnit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $isTrustedRelayPoint
     * @param string $maximumCapacity
     */
    public function __construct($name = null, $product = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, $description = null, $subUnit = '0', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $isTrustedRelayPoint = 'false', $maximumCapacity = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setLoadInformation($loadInformation)
            ->setDescription($description)
            ->setSubUnit($subUnit)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setVendorConfig($vendorConfig)
            ->setIsTrustedRelayPoint($isTrustedRelayPoint)
            ->setMaximumCapacity($maximumCapacity);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get subUnit value
     * @return string|null
     */
    public function getSubUnit()
    {
        return $this->subUnit;
    }
    /**
     * Set subUnit value
     * @param string $subUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setSubUnit($subUnit = '0')
    {
        $this->subUnit = $subUnit;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get isTrustedRelayPoint value
     * @return string|null
     */
    public function getIsTrustedRelayPoint()
    {
        return $this->isTrustedRelayPoint;
    }
    /**
     * Set isTrustedRelayPoint value
     * @param string $isTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setIsTrustedRelayPoint($isTrustedRelayPoint = 'false')
    {
        $this->isTrustedRelayPoint = $isTrustedRelayPoint;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @param string $maximumCapacity
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XTranscoder
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
}
