<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipTrunk StructType
 * @subpackage Structs
 */
class XSipTrunk extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The callingAndCalledPartyInfoFormat
     * Meta information extracted from the WSDL
     * - default: Deliver DN only in connected party
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingAndCalledPartyInfoFormat;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The referCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $referCallingSearchSpaceName;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unknownPrefix;
    /**
     * The destAddrIsSrv
     * Meta information extracted from the WSDL
     * - documentation: This tag is ignored and destAddrIsSRV is set to false if destinationaddress is an IP address and destinationport is mentioned correctly.This tag will not be returned by list.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destAddrIsSrv;
    /**
     * The tkSipCodec
     * Meta information extracted from the WSDL
     * - default: 711ulaw
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tkSipCodec;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - default: 99
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The connectedNamePresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentation;
    /**
     * The connectedPartyIdPresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedPartyIdPresentation;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingname
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingname;
    /**
     * The callingLineIdPresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The prefixDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefixDn;
    /**
     * The callerName
     * Meta information extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callerName;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The acceptInboundRdnis
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptInboundRdnis;
    /**
     * The acceptOutboundRdnis
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutboundRdnis;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The srtpFallbackAllowed
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only if srtpAllowed is set to false.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpFallbackAllowed;
    /**
     * The isPaiEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPaiEnabled;
    /**
     * The sipPrivacy
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPrivacy;
    /**
     * The isRpidEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isRpidEnabled;
    /**
     * The sipAssertedType
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipAssertedType;
    /**
     * The dtmfSignalingMethod
     * Meta information extracted from the WSDL
     * - default: No Preference
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dtmfSignalingMethod;
    /**
     * The routeClassSignalling
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The sipTrunkType
     * Meta information extracted from the WSDL
     * - documentation: This tag is not supported in the Update method.
     * - default: None(Default)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipTrunkType;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useImePublicIpPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImePublicIpPort;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The sipNormalizationScriptName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipNormalizationScriptName;
    /**
     * The runOnEveryNode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The destinations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Destinations
     */
    public $destinations;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $unknownStripDigits;
    /**
     * The cgpnTransformationUnknownCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationUnknownCssName;
    /**
     * The tunneledProtocol
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta information extracted from the WSDL
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qsigVariant;
    /**
     * The pathReplacementSupport
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The enableQsigUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableQsigUtf8;
    /**
     * The scriptParameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scriptParameters;
    /**
     * The scriptTraceEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $scriptTraceEnabled;
    /**
     * The trunkTrafficSecure
     * Meta information extracted from the WSDL
     * - default: When using both sRTP and TLS
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $trunkTrafficSecure;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The requestUriDomainName
     * Meta information extracted from the WSDL
     * - documentation: Valid only for IP Multimedia Subsystem Service Control (ISC) Sip trunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $requestUriDomainName;
    /**
     * The enableCiscoRecordingQsigTunneling
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCiscoRecordingQsigTunneling;
    /**
     * The recordingInformation
     * Meta information extracted from the WSDL
     * - documentation: This field can have values 0,1 or 2
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingInformation;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XSipTrunk
     * @uses XSipTrunk::setName()
     * @uses XSipTrunk::setProduct()
     * @uses XSipTrunk::setClass()
     * @uses XSipTrunk::setProtocol()
     * @uses XSipTrunk::setProtocolSide()
     * @uses XSipTrunk::setDevicePoolName()
     * @uses XSipTrunk::setLocationName()
     * @uses XSipTrunk::setSecurityProfileName()
     * @uses XSipTrunk::setSipProfileName()
     * @uses XSipTrunk::setPresenceGroupName()
     * @uses XSipTrunk::setCallingAndCalledPartyInfoFormat()
     * @uses XSipTrunk::setDescription()
     * @uses XSipTrunk::setCallingSearchSpaceName()
     * @uses XSipTrunk::setCommonDeviceConfigName()
     * @uses XSipTrunk::setNetworkLocation()
     * @uses XSipTrunk::setMediaResourceListName()
     * @uses XSipTrunk::setNetworkHoldMohAudioSourceId()
     * @uses XSipTrunk::setUserHoldMohAudioSourceId()
     * @uses XSipTrunk::setAutomatedAlternateRoutingCssName()
     * @uses XSipTrunk::setAarNeighborhoodName()
     * @uses XSipTrunk::setPacketCaptureMode()
     * @uses XSipTrunk::setPacketCaptureDuration()
     * @uses XSipTrunk::setLoadInformation()
     * @uses XSipTrunk::setTraceFlag()
     * @uses XSipTrunk::setMlppDomainId()
     * @uses XSipTrunk::setMlppIndicationStatus()
     * @uses XSipTrunk::setPreemption()
     * @uses XSipTrunk::setUseTrustedRelayPoint()
     * @uses XSipTrunk::setRetryVideoCallAsAudio()
     * @uses XSipTrunk::setCgpnTransformationCssName()
     * @uses XSipTrunk::setUseDevicePoolCgpnTransformCss()
     * @uses XSipTrunk::setGeoLocationName()
     * @uses XSipTrunk::setGeoLocationFilterName()
     * @uses XSipTrunk::setSendGeoLocation()
     * @uses XSipTrunk::setCdpnTransformationCssName()
     * @uses XSipTrunk::setUseDevicePoolCdpnTransformCss()
     * @uses XSipTrunk::setUnattendedPort()
     * @uses XSipTrunk::setTransmitUtf8()
     * @uses XSipTrunk::setSubscribeCallingSearchSpaceName()
     * @uses XSipTrunk::setRerouteCallingSearchSpaceName()
     * @uses XSipTrunk::setReferCallingSearchSpaceName()
     * @uses XSipTrunk::setMtpRequired()
     * @uses XSipTrunk::setUnknownPrefix()
     * @uses XSipTrunk::setDestAddrIsSrv()
     * @uses XSipTrunk::setTkSipCodec()
     * @uses XSipTrunk::setSigDigits()
     * @uses XSipTrunk::setConnectedNamePresentation()
     * @uses XSipTrunk::setConnectedPartyIdPresentation()
     * @uses XSipTrunk::setCallingPartySelection()
     * @uses XSipTrunk::setCallingname()
     * @uses XSipTrunk::setCallingLineIdPresentation()
     * @uses XSipTrunk::setPrefixDn()
     * @uses XSipTrunk::setCallerName()
     * @uses XSipTrunk::setCallerIdDn()
     * @uses XSipTrunk::setAcceptInboundRdnis()
     * @uses XSipTrunk::setAcceptOutboundRdnis()
     * @uses XSipTrunk::setSrtpAllowed()
     * @uses XSipTrunk::setSrtpFallbackAllowed()
     * @uses XSipTrunk::setIsPaiEnabled()
     * @uses XSipTrunk::setSipPrivacy()
     * @uses XSipTrunk::setIsRpidEnabled()
     * @uses XSipTrunk::setSipAssertedType()
     * @uses XSipTrunk::setDtmfSignalingMethod()
     * @uses XSipTrunk::setRouteClassSignalling()
     * @uses XSipTrunk::setSipTrunkType()
     * @uses XSipTrunk::setPstnAccess()
     * @uses XSipTrunk::setImeE164TransformationName()
     * @uses XSipTrunk::setUseImePublicIpPort()
     * @uses XSipTrunk::setUseDevicePoolCntdPnTransformationCss()
     * @uses XSipTrunk::setCntdPnTransformationCssName()
     * @uses XSipTrunk::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XSipTrunk::setSipNormalizationScriptName()
     * @uses XSipTrunk::setRunOnEveryNode()
     * @uses XSipTrunk::setDestinations()
     * @uses XSipTrunk::setUnknownStripDigits()
     * @uses XSipTrunk::setCgpnTransformationUnknownCssName()
     * @uses XSipTrunk::setTunneledProtocol()
     * @uses XSipTrunk::setAsn1RoseOidEncoding()
     * @uses XSipTrunk::setQsigVariant()
     * @uses XSipTrunk::setPathReplacementSupport()
     * @uses XSipTrunk::setEnableQsigUtf8()
     * @uses XSipTrunk::setScriptParameters()
     * @uses XSipTrunk::setScriptTraceEnabled()
     * @uses XSipTrunk::setTrunkTrafficSecure()
     * @uses XSipTrunk::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses XSipTrunk::setRequestUriDomainName()
     * @uses XSipTrunk::setEnableCiscoRecordingQsigTunneling()
     * @uses XSipTrunk::setRecordingInformation()
     * @uses XSipTrunk::setCalledPartyUnknownTransformationCssName()
     * @uses XSipTrunk::setCalledPartyUnknownPrefix()
     * @uses XSipTrunk::setCalledPartyUnknownStripDigits()
     * @uses XSipTrunk::setUseDevicePoolCalledCssUnkn()
     * @uses XSipTrunk::setConfidentialAccess()
     * @uses XSipTrunk::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $callingAndCalledPartyInfoFormat
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $unattendedPort
     * @param string $transmitUtf8
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName
     * @param string $mtpRequired
     * @param string $unknownPrefix
     * @param string $destAddrIsSrv
     * @param string $tkSipCodec
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $connectedNamePresentation
     * @param string $connectedPartyIdPresentation
     * @param string $callingPartySelection
     * @param string $callingname
     * @param string $callingLineIdPresentation
     * @param string $prefixDn
     * @param string $callerName
     * @param string $callerIdDn
     * @param string $acceptInboundRdnis
     * @param string $acceptOutboundRdnis
     * @param string $srtpAllowed
     * @param string $srtpFallbackAllowed
     * @param string $isPaiEnabled
     * @param string $sipPrivacy
     * @param string $isRpidEnabled
     * @param string $sipAssertedType
     * @param string $dtmfSignalingMethod
     * @param string $routeClassSignalling
     * @param string $sipTrunkType
     * @param string $pstnAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @param string $useImePublicIpPort
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName
     * @param string $runOnEveryNode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Destinations $destinations
     * @param int $unknownStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param string $pathReplacementSupport
     * @param string $enableQsigUtf8
     * @param string $scriptParameters
     * @param string $scriptTraceEnabled
     * @param string $trunkTrafficSecure
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $requestUriDomainName
     * @param string $enableCiscoRecordingQsigTunneling
     * @param string $recordingInformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartyUnknownStripDigits
     * @param string $useDevicePoolCalledCssUnkn
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $callingAndCalledPartyInfoFormat = 'Deliver DN only in connected party', $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $packetCaptureMode = 'None', $packetCaptureDuration = '0', \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = 'true', $unattendedPort = 'false', $transmitUtf8 = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName = null, $mtpRequired = null, $unknownPrefix = null, $destAddrIsSrv = null, $tkSipCodec = '711ulaw', \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = '99', $connectedNamePresentation = 'Default', $connectedPartyIdPresentation = 'Default', $callingPartySelection = 'Originator', $callingname = 'Default', $callingLineIdPresentation = 'Default', $prefixDn = null, $callerName = null, $callerIdDn = null, $acceptInboundRdnis = null, $acceptOutboundRdnis = null, $srtpAllowed = 'false', $srtpFallbackAllowed = 'false', $isPaiEnabled = 'true', $sipPrivacy = 'Default', $isRpidEnabled = 'true', $sipAssertedType = 'Default', $dtmfSignalingMethod = 'No Preference', $routeClassSignalling = 'Default', $sipTrunkType = None(Default), $pstnAccess = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null, $useImePublicIpPort = 'false', $useDevicePoolCntdPnTransformationCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null, $useDevicePoolCgpnTransformCssUnkn = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName = null, $runOnEveryNode = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\Destinations $destinations = null, $unknownStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName = null, $tunneledProtocol = 'None', $asn1RoseOidEncoding = 'No Changes', $qsigVariant = 'No Changes', $pathReplacementSupport = 'false', $enableQsigUtf8 = 'false', $scriptParameters = null, $scriptTraceEnabled = 'false', $trunkTrafficSecure = 'When using both sRTP and TLS', $useCallerIdCallerNameinUriOutgoingRequest = null, $requestUriDomainName = null, $enableCiscoRecordingQsigTunneling = 'false', $recordingInformation = '0', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, $calledPartyUnknownPrefix = null, $calledPartyUnknownStripDigits = null, $useDevicePoolCalledCssUnkn = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setPresenceGroupName($presenceGroupName)
            ->setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setLoadInformation($loadInformation)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setUnattendedPort($unattendedPort)
            ->setTransmitUtf8($transmitUtf8)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setReferCallingSearchSpaceName($referCallingSearchSpaceName)
            ->setMtpRequired($mtpRequired)
            ->setUnknownPrefix($unknownPrefix)
            ->setDestAddrIsSrv($destAddrIsSrv)
            ->setTkSipCodec($tkSipCodec)
            ->setSigDigits($sigDigits)
            ->setConnectedNamePresentation($connectedNamePresentation)
            ->setConnectedPartyIdPresentation($connectedPartyIdPresentation)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingname($callingname)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setPrefixDn($prefixDn)
            ->setCallerName($callerName)
            ->setCallerIdDn($callerIdDn)
            ->setAcceptInboundRdnis($acceptInboundRdnis)
            ->setAcceptOutboundRdnis($acceptOutboundRdnis)
            ->setSrtpAllowed($srtpAllowed)
            ->setSrtpFallbackAllowed($srtpFallbackAllowed)
            ->setIsPaiEnabled($isPaiEnabled)
            ->setSipPrivacy($sipPrivacy)
            ->setIsRpidEnabled($isRpidEnabled)
            ->setSipAssertedType($sipAssertedType)
            ->setDtmfSignalingMethod($dtmfSignalingMethod)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setSipTrunkType($sipTrunkType)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseImePublicIpPort($useImePublicIpPort)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setSipNormalizationScriptName($sipNormalizationScriptName)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setDestinations($destinations)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setCgpnTransformationUnknownCssName($cgpnTransformationUnknownCssName)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setEnableQsigUtf8($enableQsigUtf8)
            ->setScriptParameters($scriptParameters)
            ->setScriptTraceEnabled($scriptTraceEnabled)
            ->setTrunkTrafficSecure($trunkTrafficSecure)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setRequestUriDomainName($requestUriDomainName)
            ->setEnableCiscoRecordingQsigTunneling($enableCiscoRecordingQsigTunneling)
            ->setRecordingInformation($recordingInformation)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setConfidentialAccess($confidentialAccess)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSecurityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSipProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get callingAndCalledPartyInfoFormat value
     * @return string
     */
    public function getCallingAndCalledPartyInfoFormat()
    {
        return $this->callingAndCalledPartyInfoFormat;
    }
    /**
     * Set callingAndCalledPartyInfoFormat value
     * @param string $callingAndCalledPartyInfoFormat
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat = 'Deliver DN only in connected party')
    {
        $this->callingAndCalledPartyInfoFormat = $callingAndCalledPartyInfoFormat;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setTraceFlag($traceFlag = null)
    {
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param string $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPreemption($preemption = 'Default')
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = 'true')
    {
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = 'true')
    {
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUnattendedPort($unattendedPort = 'false')
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setTransmitUtf8($transmitUtf8 = 'false')
    {
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSubscribeCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return isset($this->rerouteCallingSearchSpaceName) ? $this->rerouteCallingSearchSpaceName : null;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setRerouteCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        if (is_null($rerouteCallingSearchSpaceName) || (is_array($rerouteCallingSearchSpaceName) && empty($rerouteCallingSearchSpaceName))) {
            unset($this->rerouteCallingSearchSpaceName);
        } else {
            $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get referCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getReferCallingSearchSpaceName()
    {
        return isset($this->referCallingSearchSpaceName) ? $this->referCallingSearchSpaceName : null;
    }
    /**
     * Set referCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setReferCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $referCallingSearchSpaceName = null)
    {
        if (is_null($referCallingSearchSpaceName) || (is_array($referCallingSearchSpaceName) && empty($referCallingSearchSpaceName))) {
            unset($this->referCallingSearchSpaceName);
        } else {
            $this->referCallingSearchSpaceName = $referCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setMtpRequired($mtpRequired = null)
    {
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get destAddrIsSrv value
     * @return string|null
     */
    public function getDestAddrIsSrv()
    {
        return $this->destAddrIsSrv;
    }
    /**
     * Set destAddrIsSrv value
     * @param string $destAddrIsSrv
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setDestAddrIsSrv($destAddrIsSrv = null)
    {
        $this->destAddrIsSrv = $destAddrIsSrv;
        return $this;
    }
    /**
     * Get tkSipCodec value
     * @return string|null
     */
    public function getTkSipCodec()
    {
        return $this->tkSipCodec;
    }
    /**
     * Set tkSipCodec value
     * @param string $tkSipCodec
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setTkSipCodec($tkSipCodec = '711ulaw')
    {
        $this->tkSipCodec = $tkSipCodec;
        return $this;
    }
    /**
     * Get sigDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return isset($this->sigDigits) ? $this->sigDigits : null;
    }
    /**
     * Set sigDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = '99')
    {
        if (is_null($sigDigits) || (is_array($sigDigits) && empty($sigDigits))) {
            unset($this->sigDigits);
        } else {
            $this->sigDigits = $sigDigits;
        }
        return $this;
    }
    /**
     * Get connectedNamePresentation value
     * @return string|null
     */
    public function getConnectedNamePresentation()
    {
        return $this->connectedNamePresentation;
    }
    /**
     * Set connectedNamePresentation value
     * @param string $connectedNamePresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setConnectedNamePresentation($connectedNamePresentation = 'Default')
    {
        $this->connectedNamePresentation = $connectedNamePresentation;
        return $this;
    }
    /**
     * Get connectedPartyIdPresentation value
     * @return string|null
     */
    public function getConnectedPartyIdPresentation()
    {
        return $this->connectedPartyIdPresentation;
    }
    /**
     * Set connectedPartyIdPresentation value
     * @param string $connectedPartyIdPresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setConnectedPartyIdPresentation($connectedPartyIdPresentation = 'Default')
    {
        $this->connectedPartyIdPresentation = $connectedPartyIdPresentation;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingname value
     * @return string|null
     */
    public function getCallingname()
    {
        return $this->callingname;
    }
    /**
     * Set callingname value
     * @param string $callingname
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallingname($callingname = 'Default')
    {
        $this->callingname = $callingname;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @param string $callingLineIdPresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = 'Default')
    {
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPrefixDn($prefixDn = null)
    {
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallerName($callerName = null)
    {
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get acceptInboundRdnis value
     * @return string|null
     */
    public function getAcceptInboundRdnis()
    {
        return $this->acceptInboundRdnis;
    }
    /**
     * Set acceptInboundRdnis value
     * @param string $acceptInboundRdnis
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setAcceptInboundRdnis($acceptInboundRdnis = null)
    {
        $this->acceptInboundRdnis = $acceptInboundRdnis;
        return $this;
    }
    /**
     * Get acceptOutboundRdnis value
     * @return string|null
     */
    public function getAcceptOutboundRdnis()
    {
        return $this->acceptOutboundRdnis;
    }
    /**
     * Set acceptOutboundRdnis value
     * @param string $acceptOutboundRdnis
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setAcceptOutboundRdnis($acceptOutboundRdnis = null)
    {
        $this->acceptOutboundRdnis = $acceptOutboundRdnis;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSrtpAllowed($srtpAllowed = 'false')
    {
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get srtpFallbackAllowed value
     * @return string|null
     */
    public function getSrtpFallbackAllowed()
    {
        return $this->srtpFallbackAllowed;
    }
    /**
     * Set srtpFallbackAllowed value
     * @param string $srtpFallbackAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSrtpFallbackAllowed($srtpFallbackAllowed = 'false')
    {
        $this->srtpFallbackAllowed = $srtpFallbackAllowed;
        return $this;
    }
    /**
     * Get isPaiEnabled value
     * @return string|null
     */
    public function getIsPaiEnabled()
    {
        return $this->isPaiEnabled;
    }
    /**
     * Set isPaiEnabled value
     * @param string $isPaiEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setIsPaiEnabled($isPaiEnabled = 'true')
    {
        $this->isPaiEnabled = $isPaiEnabled;
        return $this;
    }
    /**
     * Get sipPrivacy value
     * @return string|null
     */
    public function getSipPrivacy()
    {
        return $this->sipPrivacy;
    }
    /**
     * Set sipPrivacy value
     * @param string $sipPrivacy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSipPrivacy($sipPrivacy = 'Default')
    {
        $this->sipPrivacy = $sipPrivacy;
        return $this;
    }
    /**
     * Get isRpidEnabled value
     * @return string|null
     */
    public function getIsRpidEnabled()
    {
        return $this->isRpidEnabled;
    }
    /**
     * Set isRpidEnabled value
     * @param string $isRpidEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setIsRpidEnabled($isRpidEnabled = 'true')
    {
        $this->isRpidEnabled = $isRpidEnabled;
        return $this;
    }
    /**
     * Get sipAssertedType value
     * @return string|null
     */
    public function getSipAssertedType()
    {
        return $this->sipAssertedType;
    }
    /**
     * Set sipAssertedType value
     * @param string $sipAssertedType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSipAssertedType($sipAssertedType = 'Default')
    {
        $this->sipAssertedType = $sipAssertedType;
        return $this;
    }
    /**
     * Get dtmfSignalingMethod value
     * @return string|null
     */
    public function getDtmfSignalingMethod()
    {
        return $this->dtmfSignalingMethod;
    }
    /**
     * Set dtmfSignalingMethod value
     * @param string $dtmfSignalingMethod
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setDtmfSignalingMethod($dtmfSignalingMethod = 'No Preference')
    {
        $this->dtmfSignalingMethod = $dtmfSignalingMethod;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @param string $routeClassSignalling
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setRouteClassSignalling($routeClassSignalling = 'Default')
    {
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get sipTrunkType value
     * @return string|null
     */
    public function getSipTrunkType()
    {
        return $this->sipTrunkType;
    }
    /**
     * Set sipTrunkType value
     * @param string $sipTrunkType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSipTrunkType($sipTrunkType = None(Default))
    {
        $this->sipTrunkType = $sipTrunkType;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPstnAccess($pstnAccess = 'true')
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setImeE164TransformationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get useImePublicIpPort value
     * @return string|null
     */
    public function getUseImePublicIpPort()
    {
        return $this->useImePublicIpPort;
    }
    /**
     * Set useImePublicIpPort value
     * @param string $useImePublicIpPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseImePublicIpPort($useImePublicIpPort = 'false')
    {
        $this->useImePublicIpPort = $useImePublicIpPort;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = 'true')
    {
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCntdPnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = 'true')
    {
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get sipNormalizationScriptName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipNormalizationScriptName()
    {
        return isset($this->sipNormalizationScriptName) ? $this->sipNormalizationScriptName : null;
    }
    /**
     * Set sipNormalizationScriptName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setSipNormalizationScriptName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipNormalizationScriptName = null)
    {
        if (is_null($sipNormalizationScriptName) || (is_array($sipNormalizationScriptName) && empty($sipNormalizationScriptName))) {
            unset($this->sipNormalizationScriptName);
        } else {
            $this->sipNormalizationScriptName = $sipNormalizationScriptName;
        }
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setRunOnEveryNode($runOnEveryNode = 'false')
    {
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get destinations value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Destinations|null
     */
    public function getDestinations()
    {
        return $this->destinations;
    }
    /**
     * Set destinations value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Destinations $destinations
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setDestinations(\\Losc\CucmBundle\Model\Webservice\StructType\Destinations $destinations = null)
    {
        $this->destinations = $destinations;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationUnknownCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationUnknownCssName()
    {
        return isset($this->cgpnTransformationUnknownCssName) ? $this->cgpnTransformationUnknownCssName : null;
    }
    /**
     * Set cgpnTransformationUnknownCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCgpnTransformationUnknownCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationUnknownCssName = null)
    {
        if (is_null($cgpnTransformationUnknownCssName) || (is_array($cgpnTransformationUnknownCssName) && empty($cgpnTransformationUnknownCssName))) {
            unset($this->cgpnTransformationUnknownCssName);
        } else {
            $this->cgpnTransformationUnknownCssName = $cgpnTransformationUnknownCssName;
        }
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @param string $tunneledProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setTunneledProtocol($tunneledProtocol = 'None')
    {
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @param string $asn1RoseOidEncoding
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @param string $qsigVariant
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setQsigVariant($qsigVariant = 'No Changes')
    {
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setPathReplacementSupport($pathReplacementSupport = 'false')
    {
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get enableQsigUtf8 value
     * @return string|null
     */
    public function getEnableQsigUtf8()
    {
        return $this->enableQsigUtf8;
    }
    /**
     * Set enableQsigUtf8 value
     * @param string $enableQsigUtf8
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setEnableQsigUtf8($enableQsigUtf8 = 'false')
    {
        $this->enableQsigUtf8 = $enableQsigUtf8;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setScriptParameters($scriptParameters = null)
    {
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get scriptTraceEnabled value
     * @return string|null
     */
    public function getScriptTraceEnabled()
    {
        return $this->scriptTraceEnabled;
    }
    /**
     * Set scriptTraceEnabled value
     * @param string $scriptTraceEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setScriptTraceEnabled($scriptTraceEnabled = 'false')
    {
        $this->scriptTraceEnabled = $scriptTraceEnabled;
        return $this;
    }
    /**
     * Get trunkTrafficSecure value
     * @return string|null
     */
    public function getTrunkTrafficSecure()
    {
        return $this->trunkTrafficSecure;
    }
    /**
     * Set trunkTrafficSecure value
     * @param string $trunkTrafficSecure
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setTrunkTrafficSecure($trunkTrafficSecure = 'When using both sRTP and TLS')
    {
        $this->trunkTrafficSecure = $trunkTrafficSecure;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get requestUriDomainName value
     * @return string|null
     */
    public function getRequestUriDomainName()
    {
        return $this->requestUriDomainName;
    }
    /**
     * Set requestUriDomainName value
     * @param string $requestUriDomainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setRequestUriDomainName($requestUriDomainName = null)
    {
        $this->requestUriDomainName = $requestUriDomainName;
        return $this;
    }
    /**
     * Get enableCiscoRecordingQsigTunneling value
     * @return string|null
     */
    public function getEnableCiscoRecordingQsigTunneling()
    {
        return $this->enableCiscoRecordingQsigTunneling;
    }
    /**
     * Set enableCiscoRecordingQsigTunneling value
     * @param string $enableCiscoRecordingQsigTunneling
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setEnableCiscoRecordingQsigTunneling($enableCiscoRecordingQsigTunneling = 'false')
    {
        $this->enableCiscoRecordingQsigTunneling = $enableCiscoRecordingQsigTunneling;
        return $this;
    }
    /**
     * Get recordingInformation value
     * @return string|null
     */
    public function getRecordingInformation()
    {
        return $this->recordingInformation;
    }
    /**
     * Set recordingInformation value
     * @param string $recordingInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setRecordingInformation($recordingInformation = '0')
    {
        $this->recordingInformation = $recordingInformation;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCalledPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = 'true')
    {
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipTrunk
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
}
