<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipRoutePattern StructType
 * @subpackage Structs
 */
class XSipRoutePattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The dnOrPatternIpv6
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dnOrPatternIpv6;
    /**
     * The routeOnUserPart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeOnUserPart;
    /**
     * The useCallerCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerCss;
    /**
     * The domainRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $domainRoutingCssName;
    /**
     * Constructor method for XSipRoutePattern
     * @uses XSipRoutePattern::setPattern()
     * @uses XSipRoutePattern::setUsage()
     * @uses XSipRoutePattern::setRoutePartitionName()
     * @uses XSipRoutePattern::setUseCallingPartyPhoneMask()
     * @uses XSipRoutePattern::setSipTrunkName()
     * @uses XSipRoutePattern::setDescription()
     * @uses XSipRoutePattern::setBlockEnable()
     * @uses XSipRoutePattern::setCallingPartyTransformationMask()
     * @uses XSipRoutePattern::setCallingPartyPrefixDigits()
     * @uses XSipRoutePattern::setCallingLinePresentationBit()
     * @uses XSipRoutePattern::setCallingNamePresentationBit()
     * @uses XSipRoutePattern::setConnectedLinePresentationBit()
     * @uses XSipRoutePattern::setConnectedNamePresentationBit()
     * @uses XSipRoutePattern::setDnOrPatternIpv6()
     * @uses XSipRoutePattern::setRouteOnUserPart()
     * @uses XSipRoutePattern::setUseCallerCss()
     * @uses XSipRoutePattern::setDomainRoutingCssName()
     * @param string $pattern
     * @param string $usage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $useCallingPartyPhoneMask
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param string $description
     * @param string $blockEnable
     * @param string $callingPartyTransformationMask
     * @param string $callingPartyPrefixDigits
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param string $dnOrPatternIpv6
     * @param string $routeOnUserPart
     * @param string $useCallerCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName
     */
    public function __construct($pattern = null, $usage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $useCallingPartyPhoneMask = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, $description = null, $blockEnable = null, $callingPartyTransformationMask = null, $callingPartyPrefixDigits = null, $callingLinePresentationBit = 'Default', $callingNamePresentationBit = 'Default', $connectedLinePresentationBit = 'Default', $connectedNamePresentationBit = 'Default', $dnOrPatternIpv6 = null, $routeOnUserPart = null, $useCallerCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName = null)
    {
        $this
            ->setPattern($pattern)
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setSipTrunkName($sipTrunkName)
            ->setDescription($description)
            ->setBlockEnable($blockEnable)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setDnOrPatternIpv6($dnOrPatternIpv6)
            ->setRouteOnUserPart($routeOnUserPart)
            ->setUseCallerCss($useCallerCss)
            ->setDomainRoutingCssName($domainRoutingCssName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get usage value
     * @return string
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param string $usage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setUsage($usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param string $useCallingPartyPhoneMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = 'Default')
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setSipTrunkName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setBlockEnable($blockEnable = null)
    {
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param string $callingNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = 'Default')
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param string $connectedLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = 'Default')
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param string $connectedNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = 'Default')
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get dnOrPatternIpv6 value
     * @return string|null
     */
    public function getDnOrPatternIpv6()
    {
        return $this->dnOrPatternIpv6;
    }
    /**
     * Set dnOrPatternIpv6 value
     * @param string $dnOrPatternIpv6
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setDnOrPatternIpv6($dnOrPatternIpv6 = null)
    {
        $this->dnOrPatternIpv6 = $dnOrPatternIpv6;
        return $this;
    }
    /**
     * Get routeOnUserPart value
     * @return string|null
     */
    public function getRouteOnUserPart()
    {
        return $this->routeOnUserPart;
    }
    /**
     * Set routeOnUserPart value
     * @param string $routeOnUserPart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setRouteOnUserPart($routeOnUserPart = null)
    {
        $this->routeOnUserPart = $routeOnUserPart;
        return $this;
    }
    /**
     * Get useCallerCss value
     * @return string|null
     */
    public function getUseCallerCss()
    {
        return $this->useCallerCss;
    }
    /**
     * Set useCallerCss value
     * @param string $useCallerCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setUseCallerCss($useCallerCss = null)
    {
        $this->useCallerCss = $useCallerCss;
        return $this;
    }
    /**
     * Get domainRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDomainRoutingCssName()
    {
        return isset($this->domainRoutingCssName) ? $this->domainRoutingCssName : null;
    }
    /**
     * Set domainRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSipRoutePattern
     */
    public function setDomainRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName = null)
    {
        if (is_null($domainRoutingCssName) || (is_array($domainRoutingCssName) && empty($domainRoutingCssName))) {
            unset($this->domainRoutingCssName);
        } else {
            $this->domainRoutingCssName = $domainRoutingCssName;
        }
        return $this;
    }
}
