<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSafForwarder StructType
 * @subpackage Structs
 */
class XSafForwarder extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The clientLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 5050
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta information extracted from the WSDL
     * - default: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta information extracted from the WSDL
     * - default: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The associatedCucms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms
     */
    public $associatedCucms;
    /**
     * Constructor method for XSafForwarder
     * @uses XSafForwarder::setName()
     * @uses XSafForwarder::setClientLabel()
     * @uses XSafForwarder::setSafSecurityProfile()
     * @uses XSafForwarder::setIpAddress()
     * @uses XSafForwarder::setDescription()
     * @uses XSafForwarder::setPort()
     * @uses XSafForwarder::setEnableTcpKeepAlive()
     * @uses XSafForwarder::setSafReconnectInterval()
     * @uses XSafForwarder::setSafNotificationsWindowSize()
     * @uses XSafForwarder::setAssociatedCucms()
     * @param string $name
     * @param string $clientLabel
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $description
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms
     */
    public function __construct($name = null, $clientLabel = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile = null, $ipAddress = null, $description = null, $port = '5050', $enableTcpKeepAlive = 'true', $safReconnectInterval = '20', $safNotificationsWindowSize = '7', \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms = null)
    {
        $this
            ->setName($name)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setDescription($description)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setAssociatedCucms($associatedCucms);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setClientLabel($clientLabel = null)
    {
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setSafSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setPort($port = '5050')
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = 'true')
    {
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @param string $safReconnectInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setSafReconnectInterval($safReconnectInterval = '20')
    {
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @param string $safNotificationsWindowSize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = '7')
    {
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return $this->associatedCucms;
    }
    /**
     * Set associatedCucms value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XSafForwarder
     */
    public function setAssociatedCucms(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms = null)
    {
        $this->associatedCucms = $associatedCucms;
        return $this;
    }
}
