<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XProcessNode StructType
 * @subpackage Structs
 */
class XProcessNode extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The processNodeRole
     * Meta information extracted from the WSDL
     * - default: CUCM Voice/Video
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $processNodeRole;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv6Name;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The cupDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cupDomain;
    /**
     * Constructor method for XProcessNode
     * @uses XProcessNode::setName()
     * @uses XProcessNode::setProcessNodeRole()
     * @uses XProcessNode::setDescription()
     * @uses XProcessNode::setMac()
     * @uses XProcessNode::setIpv6Name()
     * @uses XProcessNode::setLbmHubGroup()
     * @uses XProcessNode::setCupDomain()
     * @param string $name
     * @param string $processNodeRole
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @param string $cupDomain
     */
    public function __construct($name = null, $processNodeRole = 'CUCM Voice/Video', $description = null, $mac = null, $ipv6Name = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null, $cupDomain = null)
    {
        $this
            ->setName($name)
            ->setProcessNodeRole($processNodeRole)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setLbmHubGroup($lbmHubGroup)
            ->setCupDomain($cupDomain);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @param string $processNodeRole
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setProcessNodeRole($processNodeRole = 'CUCM Voice/Video')
    {
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setMac($mac = null)
    {
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setIpv6Name($ipv6Name = null)
    {
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return isset($this->lbmHubGroup) ? $this->lbmHubGroup : null;
    }
    /**
     * Set lbmHubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setLbmHubGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null)
    {
        if (is_null($lbmHubGroup) || (is_array($lbmHubGroup) && empty($lbmHubGroup))) {
            unset($this->lbmHubGroup);
        } else {
            $this->lbmHubGroup = $lbmHubGroup;
        }
        return $this;
    }
    /**
     * Get cupDomain value
     * @return string|null
     */
    public function getCupDomain()
    {
        return $this->cupDomain;
    }
    /**
     * Set cupDomain value
     * @param string $cupDomain
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XProcessNode
     */
    public function setCupDomain($cupDomain = null)
    {
        $this->cupDomain = $cupDomain;
        return $this;
    }
}
