<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMohAudioSource StructType
 * @subpackage Structs
 */
class XMohAudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $sourceId;
    /**
     * The multicast
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The initialAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta information extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta information extracted from the WSDL
     * - default: English United States
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The sourceFile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sourceFile;
    /**
     * The mohFileStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mohFileStatus;
    /**
     * The periodicAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $periodicAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * Constructor method for XMohAudioSource
     * @uses XMohAudioSource::setSourceId()
     * @uses XMohAudioSource::setMulticast()
     * @uses XMohAudioSource::setInitialAnnouncement()
     * @uses XMohAudioSource::setPeriodicAnnouncementInterval()
     * @uses XMohAudioSource::setLocaleAnnouncement()
     * @uses XMohAudioSource::setName()
     * @uses XMohAudioSource::setSourceFile()
     * @uses XMohAudioSource::setMohFileStatus()
     * @uses XMohAudioSource::setPeriodicAnnouncement()
     * @uses XMohAudioSource::setInitialAnnouncementPlayed()
     * @param string $sourceId
     * @param string $multicast
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $name
     * @param string $sourceFile
     * @param string $mohFileStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @param string $initialAnnouncementPlayed
     */
    public function __construct($sourceId = null, $multicast = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null, $periodicAnnouncementInterval = '30', $localeAnnouncement = 'English United States', $name = null, $sourceFile = null, $mohFileStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null, $initialAnnouncementPlayed = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setMulticast($multicast)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setName($name)
            ->setSourceFile($sourceFile)
            ->setMohFileStatus($mohFileStatus)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed);
    }
    /**
     * Get sourceId value
     * @return string
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @param string $sourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setSourceId($sourceId = null)
    {
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get multicast value
     * @return string
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setMulticast($multicast = null)
    {
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getInitialAnnouncement()
    {
        return $this->initialAnnouncement;
    }
    /**
     * Set initialAnnouncement value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setInitialAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null)
    {
        $this->initialAnnouncement = $initialAnnouncement;
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @param string $periodicAnnouncementInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = '30')
    {
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @param string $localeAnnouncement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setLocaleAnnouncement($localeAnnouncement = 'English United States')
    {
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get sourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->sourceFile;
    }
    /**
     * Set sourceFile value
     * @param string $sourceFile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setSourceFile($sourceFile = null)
    {
        $this->sourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get mohFileStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMohFileStatus()
    {
        return isset($this->mohFileStatus) ? $this->mohFileStatus : null;
    }
    /**
     * Set mohFileStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mohFileStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setMohFileStatus($mohFileStatus = null)
    {
        if (is_null($mohFileStatus) || (is_array($mohFileStatus) && empty($mohFileStatus))) {
            unset($this->mohFileStatus);
        } else {
            $this->mohFileStatus = $mohFileStatus;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return isset($this->periodicAnnouncement) ? $this->periodicAnnouncement : null;
    }
    /**
     * Set periodicAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setPeriodicAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null)
    {
        if (is_null($periodicAnnouncement) || (is_array($periodicAnnouncement) && empty($periodicAnnouncement))) {
            unset($this->periodicAnnouncement);
        } else {
            $this->periodicAnnouncement = $periodicAnnouncement;
        }
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XMohAudioSource
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
}
