<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLineAssociation StructType
 * @subpackage Structs
 */
class XLineAssociation extends AbstractStructBase
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - documentation: The directory number to be associated. This directory number must be already associated to remote destination profile.
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * Constructor method for XLineAssociation
     * @uses XLineAssociation::setUuid()
     * @uses XLineAssociation::setPattern()
     * @uses XLineAssociation::setRoutePartitionName()
     * @param string $uuid
     * @param string $pattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     */
    public function __construct($uuid = null, $pattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this
            ->setUuid($uuid)
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get uuid value
     * @return string
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLineAssociation
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLineAssociation
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLineAssociation
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
}
