<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLdapDirectory StructType
 * @subpackage Structs
 */
class XLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userSearchBase;
    /**
     * The intervalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $intervalValue;
    /**
     * The nextExecTime
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public $servers;
    /**
     * The repeatable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The scheduleUnit
     * Meta information extracted from the WSDL
     * - default: DAY
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scheduleUnit;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneNumber;
    /**
     * The mailId
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mailId;
    /**
     * The ldapFilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ldapFilter;
    /**
     * The directoryUri
     * Meta information extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $directoryUri;
    /**
     * The accessControlGroupInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The featureGroupTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureGroupTemplate;
    /**
     * The applyMask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyMask;
    /**
     * The mask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mask;
    /**
     * The applyPoolList
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $applyPoolList;
    /**
     * The addDns
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddDns
     */
    public $addDns;
    /**
     * Constructor method for XLdapDirectory
     * @uses XLdapDirectory::setName()
     * @uses XLdapDirectory::setLdapDn()
     * @uses XLdapDirectory::setLdapPassword()
     * @uses XLdapDirectory::setUserSearchBase()
     * @uses XLdapDirectory::setIntervalValue()
     * @uses XLdapDirectory::setNextExecTime()
     * @uses XLdapDirectory::setServers()
     * @uses XLdapDirectory::setRepeatable()
     * @uses XLdapDirectory::setScheduleUnit()
     * @uses XLdapDirectory::setMiddleName()
     * @uses XLdapDirectory::setPhoneNumber()
     * @uses XLdapDirectory::setMailId()
     * @uses XLdapDirectory::setLdapFilter()
     * @uses XLdapDirectory::setDirectoryUri()
     * @uses XLdapDirectory::setAccessControlGroupInfo()
     * @uses XLdapDirectory::setFeatureGroupTemplate()
     * @uses XLdapDirectory::setApplyMask()
     * @uses XLdapDirectory::setMask()
     * @uses XLdapDirectory::setApplyPoolList()
     * @uses XLdapDirectory::setAddDns()
     * @param string $name
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $intervalValue
     * @param string $nextExecTime
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @param string $repeatable
     * @param string $scheduleUnit
     * @param string $middleName
     * @param string $phoneNumber
     * @param string $mailId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter
     * @param string $directoryUri
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate
     * @param string $applyMask
     * @param string $mask
     * @param string $applyPoolList
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns
     */
    public function __construct($name = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $intervalValue = null, $nextExecTime = null, \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null, $repeatable = null, $scheduleUnit = 'DAY', $middleName = null, $phoneNumber = null, $mailId = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter = null, $directoryUri = null, \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate = null, $applyMask = 'false', $mask = null, $applyPoolList = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setIntervalValue($intervalValue)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setRepeatable($repeatable)
            ->setScheduleUnit($scheduleUnit)
            ->setMiddleName($middleName)
            ->setPhoneNumber($phoneNumber)
            ->setMailId($mailId)
            ->setLdapFilter($ldapFilter)
            ->setDirectoryUri($directoryUri)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setFeatureGroupTemplate($featureGroupTemplate)
            ->setApplyMask($applyMask)
            ->setMask($mask)
            ->setApplyPoolList($applyPoolList)
            ->setAddDns($addDns);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setLdapPassword($ldapPassword = null)
    {
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @param string $intervalValue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Servers
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setServers(\\Losc\CucmBundle\Model\Webservice\StructType\Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @param string $scheduleUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = 'DAY')
    {
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setMiddleName($middleName = null)
    {
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get mailId value
     * @return string|null
     */
    public function getMailId()
    {
        return $this->mailId;
    }
    /**
     * Set mailId value
     * @param string $mailId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setMailId($mailId = null)
    {
        $this->mailId = $mailId;
        return $this;
    }
    /**
     * Get ldapFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLdapFilter()
    {
        return isset($this->ldapFilter) ? $this->ldapFilter : null;
    }
    /**
     * Set ldapFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setLdapFilter(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ldapFilter = null)
    {
        if (is_null($ldapFilter) || (is_array($ldapFilter) && empty($ldapFilter))) {
            unset($this->ldapFilter);
        } else {
            $this->ldapFilter = $ldapFilter;
        }
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setDirectoryUri($directoryUri = null)
    {
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setAccessControlGroupInfo(\\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get featureGroupTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureGroupTemplate()
    {
        return isset($this->featureGroupTemplate) ? $this->featureGroupTemplate : null;
    }
    /**
     * Set featureGroupTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setFeatureGroupTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureGroupTemplate = null)
    {
        if (is_null($featureGroupTemplate) || (is_array($featureGroupTemplate) && empty($featureGroupTemplate))) {
            unset($this->featureGroupTemplate);
        } else {
            $this->featureGroupTemplate = $featureGroupTemplate;
        }
        return $this;
    }
    /**
     * Get applyMask value
     * @return string|null
     */
    public function getApplyMask()
    {
        return $this->applyMask;
    }
    /**
     * Set applyMask value
     * @param string $applyMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setApplyMask($applyMask = 'false')
    {
        $this->applyMask = $applyMask;
        return $this;
    }
    /**
     * Get mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMask()
    {
        return isset($this->mask) ? $this->mask : null;
    }
    /**
     * Set mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setMask($mask = null)
    {
        if (is_null($mask) || (is_array($mask) && empty($mask))) {
            unset($this->mask);
        } else {
            $this->mask = $mask;
        }
        return $this;
    }
    /**
     * Get applyPoolList value
     * @return string|null
     */
    public function getApplyPoolList()
    {
        return $this->applyPoolList;
    }
    /**
     * Set applyPoolList value
     * @param string $applyPoolList
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setApplyPoolList($applyPoolList = 'false')
    {
        $this->applyPoolList = $applyPoolList;
        return $this;
    }
    /**
     * Get addDns value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddDns|null
     */
    public function getAddDns()
    {
        return $this->addDns;
    }
    /**
     * Set addDns value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLdapDirectory
     */
    public function setAddDns(\\Losc\CucmBundle\Model\Webservice\StructType\AddDns $addDns = null)
    {
        $this->addDns = $addDns;
        return $this;
    }
}
