<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeServer StructType
 * @subpackage Structs
 */
class XImeServer extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The applicationUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $applicationUser;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - documentation: Value shpuld be between 1024 and 65535
     * - default: 5620
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - default: Authenticated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The reconnectInterval
     * Meta information extracted from the WSDL
     * - documentation: Value should be between 60 and 600
     * - default: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reconnectInterval;
    /**
     * Constructor method for XImeServer
     * @uses XImeServer::setName()
     * @uses XImeServer::setIpAddress()
     * @uses XImeServer::setApplicationUser()
     * @uses XImeServer::setDescription()
     * @uses XImeServer::setPort()
     * @uses XImeServer::setDeviceSecurityMode()
     * @uses XImeServer::setReconnectInterval()
     * @param string $name
     * @param string $ipAddress
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @param string $description
     * @param string $port
     * @param string $deviceSecurityMode
     * @param string $reconnectInterval
     */
    public function __construct($name = null, $ipAddress = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null, $description = null, $port = '5620', $deviceSecurityMode = 'Authenticated', $reconnectInterval = '120')
    {
        $this
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setApplicationUser($applicationUser)
            ->setDescription($description)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setReconnectInterval($reconnectInterval);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setApplicationUser(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setPort($port = '5620')
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @param string $deviceSecurityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setDeviceSecurityMode($deviceSecurityMode = 'Authenticated')
    {
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @param string $reconnectInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeServer
     */
    public function setReconnectInterval($reconnectInterval = '120')
    {
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
}
