<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeE164Transformation StructType
 * @subpackage Structs
 */
class XImeE164Transformation extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The isCgpnPreTransformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCgpnPreTransformation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The isCdpnPreTransformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCdpnPreTransformation;
    /**
     * The incomingCgpnTransformationProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $incomingCgpnTransformationProfileName;
    /**
     * The incomingCdpnTransformationProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $incomingCdpnTransformationProfileName;
    /**
     * Constructor method for XImeE164Transformation
     * @uses XImeE164Transformation::setName()
     * @uses XImeE164Transformation::setDescription()
     * @uses XImeE164Transformation::setCgpnTransformationCssName()
     * @uses XImeE164Transformation::setIsCgpnPreTransformation()
     * @uses XImeE164Transformation::setCdpnTransformationCssName()
     * @uses XImeE164Transformation::setIsCdpnPreTransformation()
     * @uses XImeE164Transformation::setIncomingCgpnTransformationProfileName()
     * @uses XImeE164Transformation::setIncomingCdpnTransformationProfileName()
     * @param string $name
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $isCgpnPreTransformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $isCdpnPreTransformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName
     */
    public function __construct($name = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $isCgpnPreTransformation = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $isCdpnPreTransformation = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setIsCgpnPreTransformation($isCgpnPreTransformation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setIsCdpnPreTransformation($isCdpnPreTransformation)
            ->setIncomingCgpnTransformationProfileName($incomingCgpnTransformationProfileName)
            ->setIncomingCdpnTransformationProfileName($incomingCdpnTransformationProfileName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get isCgpnPreTransformation value
     * @return string|null
     */
    public function getIsCgpnPreTransformation()
    {
        return $this->isCgpnPreTransformation;
    }
    /**
     * Set isCgpnPreTransformation value
     * @param string $isCgpnPreTransformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setIsCgpnPreTransformation($isCgpnPreTransformation = 'false')
    {
        $this->isCgpnPreTransformation = $isCgpnPreTransformation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get isCdpnPreTransformation value
     * @return string|null
     */
    public function getIsCdpnPreTransformation()
    {
        return $this->isCdpnPreTransformation;
    }
    /**
     * Set isCdpnPreTransformation value
     * @param string $isCdpnPreTransformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setIsCdpnPreTransformation($isCdpnPreTransformation = 'false')
    {
        $this->isCdpnPreTransformation = $isCdpnPreTransformation;
        return $this;
    }
    /**
     * Get incomingCgpnTransformationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIncomingCgpnTransformationProfileName()
    {
        return isset($this->incomingCgpnTransformationProfileName) ? $this->incomingCgpnTransformationProfileName : null;
    }
    /**
     * Set incomingCgpnTransformationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setIncomingCgpnTransformationProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCgpnTransformationProfileName = null)
    {
        if (is_null($incomingCgpnTransformationProfileName) || (is_array($incomingCgpnTransformationProfileName) && empty($incomingCgpnTransformationProfileName))) {
            unset($this->incomingCgpnTransformationProfileName);
        } else {
            $this->incomingCgpnTransformationProfileName = $incomingCgpnTransformationProfileName;
        }
        return $this;
    }
    /**
     * Get incomingCdpnTransformationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getIncomingCdpnTransformationProfileName()
    {
        return isset($this->incomingCdpnTransformationProfileName) ? $this->incomingCdpnTransformationProfileName : null;
    }
    /**
     * Set incomingCdpnTransformationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XImeE164Transformation
     */
    public function setIncomingCdpnTransformationProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        if (is_null($incomingCdpnTransformationProfileName) || (is_array($incomingCdpnTransformationProfileName) && empty($incomingCdpnTransformationProfileName))) {
            unset($this->incomingCdpnTransformationProfileName);
        } else {
            $this->incomingCdpnTransformationProfileName = $incomingCdpnTransformationProfileName;
        }
        return $this;
    }
}
