<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XH323Line StructType
 * @subpackage Structs
 */
class XH323Line extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XDirn
     */
    public $dirn;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $display;
    /**
     * The displayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $e164Mask;
    /**
     * The maxNumCalls
     * Meta information extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - default: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - default: Call Recording Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - default: General
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XH323Line
     * @uses XH323Line::setIndex()
     * @uses XH323Line::setDirn()
     * @uses XH323Line::setLabel()
     * @uses XH323Line::setAsciiLabel()
     * @uses XH323Line::setDisplay()
     * @uses XH323Line::setDisplayAscii()
     * @uses XH323Line::setE164Mask()
     * @uses XH323Line::setMaxNumCalls()
     * @uses XH323Line::setBusyTrigger()
     * @uses XH323Line::setCallInfoDisplay()
     * @uses XH323Line::setRecordingProfileName()
     * @uses XH323Line::setMonitoringCssName()
     * @uses XH323Line::setRecordingFlag()
     * @uses XH323Line::setAudibleMwi()
     * @uses XH323Line::setSpeedDial()
     * @uses XH323Line::setPartitionUsage()
     * @uses XH323Line::setAssociatedEndusers()
     * @uses XH323Line::setCtiid()
     * @param string $index
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @param int $ctiid
     */
    public function __construct($index = null, \\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn = null, $label = null, $asciiLabel = null, $display = null, $displayAscii = null, $e164Mask = null, $maxNumCalls = '2', $busyTrigger = '1', \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null, $recordingFlag = 'Call Recording Disabled', $audibleMwi = 'Default', $speedDial = null, $partitionUsage = 'General', \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setDirn($dirn)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setIndex($index = null)
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Get dirn value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirn
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setDirn(\\Losc\CucmBundle\Model\Webservice\StructType\XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setLabel($label = null)
    {
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setDisplay($display = null)
    {
        $this->display = $display;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setDisplayAscii($displayAscii = null)
    {
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getE164Mask()
    {
        return isset($this->e164Mask) ? $this->e164Mask : null;
    }
    /**
     * Set e164Mask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $e164Mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setE164Mask($e164Mask = null)
    {
        if (is_null($e164Mask) || (is_array($e164Mask) && empty($e164Mask))) {
            unset($this->e164Mask);
        } else {
            $this->e164Mask = $e164Mask;
        }
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @param string $maxNumCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setMaxNumCalls($maxNumCalls = '2')
    {
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @param string $busyTrigger
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setBusyTrigger($busyTrigger = '1')
    {
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setCallInfoDisplay(\\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return isset($this->recordingProfileName) ? $this->recordingProfileName : null;
    }
    /**
     * Set recordingProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setRecordingProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null)
    {
        if (is_null($recordingProfileName) || (is_array($recordingProfileName) && empty($recordingProfileName))) {
            unset($this->recordingProfileName);
        } else {
            $this->recordingProfileName = $recordingProfileName;
        }
        return $this;
    }
    /**
     * Get monitoringCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return isset($this->monitoringCssName) ? $this->monitoringCssName : null;
    }
    /**
     * Set monitoringCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setMonitoringCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null)
    {
        if (is_null($monitoringCssName) || (is_array($monitoringCssName) && empty($monitoringCssName))) {
            unset($this->monitoringCssName);
        } else {
            $this->monitoringCssName = $monitoringCssName;
        }
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @param string $recordingFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setRecordingFlag($recordingFlag = 'Call Recording Disabled')
    {
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @param string $audibleMwi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setAudibleMwi($audibleMwi = 'Default')
    {
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpeedDial()
    {
        return isset($this->speedDial) ? $this->speedDial : null;
    }
    /**
     * Set speedDial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $speedDial
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setSpeedDial($speedDial = null)
    {
        if (is_null($speedDial) || (is_array($speedDial) && empty($speedDial))) {
            unset($this->speedDial);
        } else {
            $this->speedDial = $speedDial;
        }
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @param string $partitionUsage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setPartitionUsage($partitionUsage = 'General')
    {
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setAssociatedEndusers(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XH323Line
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
}
