<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatewaySubunits StructType
 * @subpackage Structs
 */
class XGatewaySubunits extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - documentation: pkid of the Gateway
     * - base: xsd:string
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $unit;
    /**
     * The subunits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Subunits
     */
    public $subunits;
    /**
     * Constructor method for XGatewaySubunits
     * @uses XGatewaySubunits::setDomainName()
     * @uses XGatewaySubunits::setGatewayUuid()
     * @uses XGatewaySubunits::setUnit()
     * @uses XGatewaySubunits::setSubunits()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $unit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits
     */
    public function __construct($domainName = null, $gatewayUuid = null, $unit = '0', \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnit($unit)
            ->setSubunits($subunits);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewaySubunits
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $gatewayUuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewaySubunits
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get unit value
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewaySubunits
     */
    public function setUnit($unit = '0')
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Subunits
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatewaySubunits
     */
    public function setSubunits(\\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
}
