<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XExternalCallControlProfile StructType
 * @subpackage Structs
 */
class XExternalCallControlProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The primaryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $primaryUri;
    /**
     * The callTreatmentOnFailure
     * Meta information extracted from the WSDL
     * - default: Allow Calls
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callTreatmentOnFailure;
    /**
     * The secondaryUri
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secondaryUri;
    /**
     * The enableLoadBalancing
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableLoadBalancing;
    /**
     * The routingRequestTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $routingRequestTimer;
    /**
     * The diversionReroutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $diversionReroutingCssName;
    /**
     * Constructor method for XExternalCallControlProfile
     * @uses XExternalCallControlProfile::setName()
     * @uses XExternalCallControlProfile::setPrimaryUri()
     * @uses XExternalCallControlProfile::setCallTreatmentOnFailure()
     * @uses XExternalCallControlProfile::setSecondaryUri()
     * @uses XExternalCallControlProfile::setEnableLoadBalancing()
     * @uses XExternalCallControlProfile::setRoutingRequestTimer()
     * @uses XExternalCallControlProfile::setDiversionReroutingCssName()
     * @param string $name
     * @param string $primaryUri
     * @param string $callTreatmentOnFailure
     * @param string $secondaryUri
     * @param string $enableLoadBalancing
     * @param string $routingRequestTimer
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName
     */
    public function __construct($name = null, $primaryUri = null, $callTreatmentOnFailure = 'Allow Calls', $secondaryUri = null, $enableLoadBalancing = 'false', $routingRequestTimer = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName = null)
    {
        $this
            ->setName($name)
            ->setPrimaryUri($primaryUri)
            ->setCallTreatmentOnFailure($callTreatmentOnFailure)
            ->setSecondaryUri($secondaryUri)
            ->setEnableLoadBalancing($enableLoadBalancing)
            ->setRoutingRequestTimer($routingRequestTimer)
            ->setDiversionReroutingCssName($diversionReroutingCssName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get primaryUri value
     * @return string
     */
    public function getPrimaryUri()
    {
        return $this->primaryUri;
    }
    /**
     * Set primaryUri value
     * @param string $primaryUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setPrimaryUri($primaryUri = null)
    {
        $this->primaryUri = $primaryUri;
        return $this;
    }
    /**
     * Get callTreatmentOnFailure value
     * @return string
     */
    public function getCallTreatmentOnFailure()
    {
        return $this->callTreatmentOnFailure;
    }
    /**
     * Set callTreatmentOnFailure value
     * @param string $callTreatmentOnFailure
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setCallTreatmentOnFailure($callTreatmentOnFailure = 'Allow Calls')
    {
        $this->callTreatmentOnFailure = $callTreatmentOnFailure;
        return $this;
    }
    /**
     * Get secondaryUri value
     * @return string|null
     */
    public function getSecondaryUri()
    {
        return $this->secondaryUri;
    }
    /**
     * Set secondaryUri value
     * @param string $secondaryUri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setSecondaryUri($secondaryUri = null)
    {
        $this->secondaryUri = $secondaryUri;
        return $this;
    }
    /**
     * Get enableLoadBalancing value
     * @return string|null
     */
    public function getEnableLoadBalancing()
    {
        return $this->enableLoadBalancing;
    }
    /**
     * Set enableLoadBalancing value
     * @param string $enableLoadBalancing
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setEnableLoadBalancing($enableLoadBalancing = 'false')
    {
        $this->enableLoadBalancing = $enableLoadBalancing;
        return $this;
    }
    /**
     * Get routingRequestTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingRequestTimer()
    {
        return isset($this->routingRequestTimer) ? $this->routingRequestTimer : null;
    }
    /**
     * Set routingRequestTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routingRequestTimer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setRoutingRequestTimer($routingRequestTimer = null)
    {
        if (is_null($routingRequestTimer) || (is_array($routingRequestTimer) && empty($routingRequestTimer))) {
            unset($this->routingRequestTimer);
        } else {
            $this->routingRequestTimer = $routingRequestTimer;
        }
        return $this;
    }
    /**
     * Get diversionReroutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDiversionReroutingCssName()
    {
        return isset($this->diversionReroutingCssName) ? $this->diversionReroutingCssName : null;
    }
    /**
     * Set diversionReroutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XExternalCallControlProfile
     */
    public function setDiversionReroutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $diversionReroutingCssName = null)
    {
        if (is_null($diversionReroutingCssName) || (is_array($diversionReroutingCssName) && empty($diversionReroutingCssName))) {
            unset($this->diversionReroutingCssName);
        } else {
            $this->diversionReroutingCssName = $diversionReroutingCssName;
        }
        return $this;
    }
}
