<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XEmccFeatureConfig StructType
 * @subpackage Structs
 */
class XEmccFeatureConfig extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $parameterName;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for XEmccFeatureConfig
     * @uses XEmccFeatureConfig::setParameterName()
     * @uses XEmccFeatureConfig::setValue()
     * @param string $parameterName
     * @param string $value
     */
    public function __construct($parameterName = null, $value = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setValue($value);
    }
    /**
     * Get parameterName value
     * @return string
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XEmccFeatureConfig
     */
    public function setParameterName($parameterName = null)
    {
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XEmccFeatureConfig
     */
    public function setValue($value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
}
