<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDirectedCallPark StructType
 * @subpackage Structs
 */
class XDirectedCallPark extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The retrievalPrefix
     * Meta information extracted from the WSDL
     * - documentation: The prefix used for park-code retrieval. User will dial prefix plus park code to retrieve a parked call.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $retrievalPrefix;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The reversionPattern
     * Meta information extracted from the WSDL
     * - documentation: The pattern used to revert the call when the parked call is not retrieved within retrieval timer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $reversionPattern;
    /**
     * The revertCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $revertCssName;
    /**
     * Constructor method for XDirectedCallPark
     * @uses XDirectedCallPark::setPattern()
     * @uses XDirectedCallPark::setRetrievalPrefix()
     * @uses XDirectedCallPark::setDescription()
     * @uses XDirectedCallPark::setRoutePartitionName()
     * @uses XDirectedCallPark::setReversionPattern()
     * @uses XDirectedCallPark::setRevertCssName()
     * @param string $pattern
     * @param string $retrievalPrefix
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $reversionPattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName
     */
    public function __construct($pattern = null, $retrievalPrefix = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $reversionPattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName = null)
    {
        $this
            ->setPattern($pattern)
            ->setRetrievalPrefix($retrievalPrefix)
            ->setDescription($description)
            ->setRoutePartitionName($routePartitionName)
            ->setReversionPattern($reversionPattern)
            ->setRevertCssName($revertCssName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirectedCallPark
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get retrievalPrefix value
     * @return string
     */
    public function getRetrievalPrefix()
    {
        return $this->retrievalPrefix;
    }
    /**
     * Set retrievalPrefix value
     * @param string $retrievalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirectedCallPark
     */
    public function setRetrievalPrefix($retrievalPrefix = null)
    {
        $this->retrievalPrefix = $retrievalPrefix;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirectedCallPark
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirectedCallPark
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get reversionPattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReversionPattern()
    {
        return isset($this->reversionPattern) ? $this->reversionPattern : null;
    }
    /**
     * Set reversionPattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reversionPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirectedCallPark
     */
    public function setReversionPattern($reversionPattern = null)
    {
        if (is_null($reversionPattern) || (is_array($reversionPattern) && empty($reversionPattern))) {
            unset($this->reversionPattern);
        } else {
            $this->reversionPattern = $reversionPattern;
        }
        return $this;
    }
    /**
     * Get revertCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRevertCssName()
    {
        return isset($this->revertCssName) ? $this->revertCssName : null;
    }
    /**
     * Set revertCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDirectedCallPark
     */
    public function setRevertCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $revertCssName = null)
    {
        if (is_null($revertCssName) || (is_array($revertCssName) && empty($revertCssName))) {
            unset($this->revertCssName);
        } else {
            $this->revertCssName = $revertCssName;
        }
        return $this;
    }
}
