<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDefaultDeviceProfile StructType
 * @subpackage Structs
 */
class XDefaultDeviceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The phoneButtonTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $phoneButtonTemplate;
    /**
     * The softkeyTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $softkeyTemplate;
    /**
     * The privacy
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacy;
    /**
     * The mlppIndication
     * Meta information extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mlppIndication;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The ignorePi
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePi;
    /**
     * The dndStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The emccCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $emccCallingSearchSpace;
    /**
     * Constructor method for XDefaultDeviceProfile
     * @uses XDefaultDeviceProfile::setName()
     * @uses XDefaultDeviceProfile::setProduct()
     * @uses XDefaultDeviceProfile::setClass()
     * @uses XDefaultDeviceProfile::setProtocol()
     * @uses XDefaultDeviceProfile::setProtocolSide()
     * @uses XDefaultDeviceProfile::setPhoneButtonTemplate()
     * @uses XDefaultDeviceProfile::setSoftkeyTemplate()
     * @uses XDefaultDeviceProfile::setPrivacy()
     * @uses XDefaultDeviceProfile::setMlppIndication()
     * @uses XDefaultDeviceProfile::setPreemption()
     * @uses XDefaultDeviceProfile::setDescription()
     * @uses XDefaultDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses XDefaultDeviceProfile::setUserLocale()
     * @uses XDefaultDeviceProfile::setSingleButtonBarge()
     * @uses XDefaultDeviceProfile::setJoinAcrossLines()
     * @uses XDefaultDeviceProfile::setIgnorePi()
     * @uses XDefaultDeviceProfile::setDndStatus()
     * @uses XDefaultDeviceProfile::setDndRingSetting()
     * @uses XDefaultDeviceProfile::setDndOption()
     * @uses XDefaultDeviceProfile::setMlppDomainId()
     * @uses XDefaultDeviceProfile::setAlwaysUsePrimeLine()
     * @uses XDefaultDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XDefaultDeviceProfile::setEmccCallingSearchSpace()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneButtonTemplate
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplate
     * @param string $privacy
     * @param string $mlppIndication
     * @param string $preemption
     * @param string $description
     * @param string $userHoldMohAudioSourceId
     * @param string $userLocale
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $ignorePi
     * @param string $dndStatus
     * @param string $dndRingSetting
     * @param string $dndOption
     * @param string $mlppDomainId
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpace
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneButtonTemplate = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplate = null, $privacy = 'Default', $mlppIndication = 'Off', $preemption = 'Default', $description = null, $userHoldMohAudioSourceId = null, $userLocale = null, $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', $ignorePi = null, $dndStatus = null, $dndRingSetting = null, $dndOption = 'Ringer Off', $mlppDomainId = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpace = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setPhoneButtonTemplate($phoneButtonTemplate)
            ->setSoftkeyTemplate($softkeyTemplate)
            ->setPrivacy($privacy)
            ->setMlppIndication($mlppIndication)
            ->setPreemption($preemption)
            ->setDescription($description)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setIgnorePi($ignorePi)
            ->setDndStatus($dndStatus)
            ->setDndRingSetting($dndRingSetting)
            ->setDndOption($dndOption)
            ->setMlppDomainId($mlppDomainId)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get phoneButtonTemplate value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPhoneButtonTemplate()
    {
        return $this->phoneButtonTemplate;
    }
    /**
     * Set phoneButtonTemplate value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneButtonTemplate
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setPhoneButtonTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneButtonTemplate = null)
    {
        $this->phoneButtonTemplate = $phoneButtonTemplate;
        return $this;
    }
    /**
     * Get softkeyTemplate value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getSoftkeyTemplate()
    {
        return $this->softkeyTemplate;
    }
    /**
     * Set softkeyTemplate value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplate
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setSoftkeyTemplate(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplate = null)
    {
        $this->softkeyTemplate = $softkeyTemplate;
        return $this;
    }
    /**
     * Get privacy value
     * @return string
     */
    public function getPrivacy()
    {
        return $this->privacy;
    }
    /**
     * Set privacy value
     * @param string $privacy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setPrivacy($privacy = 'Default')
    {
        $this->privacy = $privacy;
        return $this;
    }
    /**
     * Get mlppIndication value
     * @return string
     */
    public function getMlppIndication()
    {
        return $this->mlppIndication;
    }
    /**
     * Set mlppIndication value
     * @param string $mlppIndication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setMlppIndication($mlppIndication = 'Off')
    {
        $this->mlppIndication = $mlppIndication;
        return $this;
    }
    /**
     * Get preemption value
     * @return string
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param string $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setPreemption($preemption = 'Default')
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param string $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param string $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get ignorePi value
     * @return string|null
     */
    public function getIgnorePi()
    {
        return $this->ignorePi;
    }
    /**
     * Set ignorePi value
     * @param string $ignorePi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setIgnorePi($ignorePi = null)
    {
        $this->ignorePi = $ignorePi;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setDndStatus($dndStatus = null)
    {
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return isset($this->dndRingSetting) ? $this->dndRingSetting : null;
    }
    /**
     * Set dndRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dndRingSetting
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        if (is_null($dndRingSetting) || (is_array($dndRingSetting) && empty($dndRingSetting))) {
            unset($this->dndRingSetting);
        } else {
            $this->dndRingSetting = $dndRingSetting;
        }
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param string $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param string $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return isset($this->emccCallingSearchSpace) ? $this->emccCallingSearchSpace : null;
    }
    /**
     * Set emccCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XDefaultDeviceProfile
     */
    public function setEmccCallingSearchSpace(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $emccCallingSearchSpace = null)
    {
        if (is_null($emccCallingSearchSpace) || (is_array($emccCallingSearchSpace) && empty($emccCallingSearchSpace))) {
            unset($this->emccCallingSearchSpace);
        } else {
            $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        }
        return $this;
    }
}
