<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCommonDeviceConfig StructType
 * @subpackage Structs
 */
class XCommonDeviceConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XUserLocale in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: Nullable
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - documentation: Default is not applicable for CommonDeviceConfig API
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affect devices that support MLPP
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The ipAddressingMode
     * Meta information extracted from the WSDL
     * - default: IPv4 and IPv6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressingMode;
    /**
     * The ipAddressingModePreferenceControl
     * Meta information extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddressingModePreferenceControl;
    /**
     * The allowAutoConfigurationForPhones
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $allowAutoConfigurationForPhones;
    /**
     * The useImeForOutboundCalls
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The allowDuplicateAddressDetection
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $allowDuplicateAddressDetection;
    /**
     * The acceptRedirectMessages
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $acceptRedirectMessages;
    /**
     * The replyMulticastEchoRequest
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $replyMulticastEchoRequest;
    /**
     * Constructor method for XCommonDeviceConfig
     * @uses XCommonDeviceConfig::setName()
     * @uses XCommonDeviceConfig::setSoftkeyTemplateName()
     * @uses XCommonDeviceConfig::setUserLocale()
     * @uses XCommonDeviceConfig::setNetworkHoldMohAudioSourceId()
     * @uses XCommonDeviceConfig::setUserHoldMohAudioSourceId()
     * @uses XCommonDeviceConfig::setMlppDomainId()
     * @uses XCommonDeviceConfig::setMlppIndicationStatus()
     * @uses XCommonDeviceConfig::setUseTrustedRelayPoint()
     * @uses XCommonDeviceConfig::setPreemption()
     * @uses XCommonDeviceConfig::setIpAddressingMode()
     * @uses XCommonDeviceConfig::setIpAddressingModePreferenceControl()
     * @uses XCommonDeviceConfig::setAllowAutoConfigurationForPhones()
     * @uses XCommonDeviceConfig::setUseImeForOutboundCalls()
     * @uses XCommonDeviceConfig::setConfidentialAccess()
     * @uses XCommonDeviceConfig::setAllowDuplicateAddressDetection()
     * @uses XCommonDeviceConfig::setAcceptRedirectMessages()
     * @uses XCommonDeviceConfig::setReplyMulticastEchoRequest()
     * @param string $name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @param string $userLocale
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $useTrustedRelayPoint
     * @param string $preemption
     * @param string $ipAddressingMode
     * @param string $ipAddressingModePreferenceControl
     * @param string $allowAutoConfigurationForPhones
     * @param string $useImeForOutboundCalls
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param string $allowDuplicateAddressDetection
     * @param string $acceptRedirectMessages
     * @param string $replyMulticastEchoRequest
     */
    public function __construct($name = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null, $userLocale = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $mlppDomainId = null, $mlppIndicationStatus = 'Default', $useTrustedRelayPoint = 'false', $preemption = 'Default', $ipAddressingMode = 'IPv4 and IPv6', $ipAddressingModePreferenceControl = 'Use System Default', $allowAutoConfigurationForPhones = 'Default', $useImeForOutboundCalls = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $allowDuplicateAddressDetection = 'Default', $acceptRedirectMessages = 'Default', $replyMulticastEchoRequest = 'Default')
    {
        $this
            ->setName($name)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setUserLocale($userLocale)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPreemption($preemption)
            ->setIpAddressingMode($ipAddressingMode)
            ->setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl)
            ->setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls)
            ->setConfidentialAccess($confidentialAccess)
            ->setAllowDuplicateAddressDetection($allowDuplicateAddressDetection)
            ->setAcceptRedirectMessages($acceptRedirectMessages)
            ->setReplyMulticastEchoRequest($replyMulticastEchoRequest);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return isset($this->softkeyTemplateName) ? $this->softkeyTemplateName : null;
    }
    /**
     * Set softkeyTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setSoftkeyTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null)
    {
        if (is_null($softkeyTemplateName) || (is_array($softkeyTemplateName) && empty($softkeyTemplateName))) {
            unset($this->softkeyTemplateName);
        } else {
            $this->softkeyTemplateName = $softkeyTemplateName;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Default')
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'false')
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param string $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setPreemption($preemption = 'Default')
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get ipAddressingMode value
     * @return string|null
     */
    public function getIpAddressingMode()
    {
        return $this->ipAddressingMode;
    }
    /**
     * Set ipAddressingMode value
     * @param string $ipAddressingMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setIpAddressingMode($ipAddressingMode = 'IPv4 and IPv6')
    {
        $this->ipAddressingMode = $ipAddressingMode;
        return $this;
    }
    /**
     * Get ipAddressingModePreferenceControl value
     * @return string|null
     */
    public function getIpAddressingModePreferenceControl()
    {
        return $this->ipAddressingModePreferenceControl;
    }
    /**
     * Set ipAddressingModePreferenceControl value
     * @param string $ipAddressingModePreferenceControl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl = 'Use System Default')
    {
        $this->ipAddressingModePreferenceControl = $ipAddressingModePreferenceControl;
        return $this;
    }
    /**
     * Get allowAutoConfigurationForPhones value
     * @return string|null
     */
    public function getAllowAutoConfigurationForPhones()
    {
        return $this->allowAutoConfigurationForPhones;
    }
    /**
     * Set allowAutoConfigurationForPhones value
     * @param string $allowAutoConfigurationForPhones
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones = 'Default')
    {
        $this->allowAutoConfigurationForPhones = $allowAutoConfigurationForPhones;
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return $this->useImeForOutboundCalls;
    }
    /**
     * Set useImeForOutboundCalls value
     * @param string $useImeForOutboundCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = 'Default')
    {
        $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get allowDuplicateAddressDetection value
     * @return string|null
     */
    public function getAllowDuplicateAddressDetection()
    {
        return $this->allowDuplicateAddressDetection;
    }
    /**
     * Set allowDuplicateAddressDetection value
     * @param string $allowDuplicateAddressDetection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setAllowDuplicateAddressDetection($allowDuplicateAddressDetection = 'Default')
    {
        $this->allowDuplicateAddressDetection = $allowDuplicateAddressDetection;
        return $this;
    }
    /**
     * Get acceptRedirectMessages value
     * @return string|null
     */
    public function getAcceptRedirectMessages()
    {
        return $this->acceptRedirectMessages;
    }
    /**
     * Set acceptRedirectMessages value
     * @param string $acceptRedirectMessages
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setAcceptRedirectMessages($acceptRedirectMessages = 'Default')
    {
        $this->acceptRedirectMessages = $acceptRedirectMessages;
        return $this;
    }
    /**
     * Get replyMulticastEchoRequest value
     * @return string|null
     */
    public function getReplyMulticastEchoRequest()
    {
        return $this->replyMulticastEchoRequest;
    }
    /**
     * Set replyMulticastEchoRequest value
     * @param string $replyMulticastEchoRequest
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCommonDeviceConfig
     */
    public function setReplyMulticastEchoRequest($replyMulticastEchoRequest = 'Default')
    {
        $this->replyMulticastEchoRequest = $replyMulticastEchoRequest;
        return $this;
    }
}
