<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCcdHostedDN StructType
 * @subpackage Structs
 */
class XCcdHostedDN extends AbstractStructBase
{
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostedPattern;
    /**
     * The CcdHostedDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $CcdHostedDnGroup;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * Constructor method for XCcdHostedDN
     * @uses XCcdHostedDN::setHostedPattern()
     * @uses XCcdHostedDN::setCcdHostedDnGroup()
     * @uses XCcdHostedDN::setDescription()
     * @uses XCcdHostedDN::setPstnFailoverStripDigits()
     * @uses XCcdHostedDN::setPstnFailoverPrependDigits()
     * @uses XCcdHostedDN::setUsePstnFailover()
     * @param string $hostedPattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup
     * @param string $description
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     */
    public function __construct($hostedPattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup = null, $description = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = 'false')
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setCcdHostedDnGroup($ccdHostedDnGroup)
            ->setDescription($description)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover);
    }
    /**
     * Get hostedPattern value
     * @return string
     */
    public function getHostedPattern()
    {
        return $this->hostedPattern;
    }
    /**
     * Set hostedPattern value
     * @param string $hostedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDN
     */
    public function setHostedPattern($hostedPattern = null)
    {
        $this->hostedPattern = $hostedPattern;
        return $this;
    }
    /**
     * Get CcdHostedDnGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCcdHostedDnGroup()
    {
        return $this->CcdHostedDnGroup;
    }
    /**
     * Set CcdHostedDnGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDN
     */
    public function setCcdHostedDnGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup = null)
    {
        $this->CcdHostedDnGroup = $ccdHostedDnGroup;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDN
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return isset($this->pstnFailoverStripDigits) ? $this->pstnFailoverStripDigits : null;
    }
    /**
     * Set pstnFailoverStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pstnFailoverStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDN
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        if (is_null($pstnFailoverStripDigits) || (is_array($pstnFailoverStripDigits) && empty($pstnFailoverStripDigits))) {
            unset($this->pstnFailoverStripDigits);
        } else {
            $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        }
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDN
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDN
     */
    public function setUsePstnFailover($usePstnFailover = 'false')
    {
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
}
