<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallingPartyTransformationPattern StructType
 * @subpackage Structs
 */
class XCallingPartyTransformationPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartyNumberType;
    /**
     * The mlppPreemptionDisabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mlppPreemptionDisabled;
    /**
     * Constructor method for XCallingPartyTransformationPattern
     * @uses XCallingPartyTransformationPattern::setPattern()
     * @uses XCallingPartyTransformationPattern::setRoutePartitionName()
     * @uses XCallingPartyTransformationPattern::setDescription()
     * @uses XCallingPartyTransformationPattern::setCallingPartyTransformationMask()
     * @uses XCallingPartyTransformationPattern::setUseCallingPartyPhoneMask()
     * @uses XCallingPartyTransformationPattern::setDialPlanName()
     * @uses XCallingPartyTransformationPattern::setDigitDiscardInstructionName()
     * @uses XCallingPartyTransformationPattern::setCallingPartyPrefixDigits()
     * @uses XCallingPartyTransformationPattern::setRouteFilterName()
     * @uses XCallingPartyTransformationPattern::setCallingLinePresentationBit()
     * @uses XCallingPartyTransformationPattern::setCallingPartyNumberingPlan()
     * @uses XCallingPartyTransformationPattern::setCallingPartyNumberType()
     * @uses XCallingPartyTransformationPattern::setMlppPreemptionDisabled()
     * @param string $pattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $description
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @param string $callingPartyPrefixDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @param string $callingLinePresentationBit
     * @param string $callingPartyNumberingPlan
     * @param string $callingPartyNumberType
     * @param string $mlppPreemptionDisabled
     */
    public function __construct($pattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $description = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null, $callingPartyPrefixDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null, $callingLinePresentationBit = 'Default', $callingPartyNumberingPlan = 'Cisco CallManager', $callingPartyNumberType = 'Cisco CallManager', $mlppPreemptionDisabled = 'false')
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDescription($description)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setMlppPreemptionDisabled($mlppPreemptionDisabled);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setPattern($pattern = null)
    {
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param string $useCallingPartyPhoneMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = 'Default')
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * Set dialPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setDialPlanName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialPlanName = null)
    {
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return isset($this->digitDiscardInstructionName) ? $this->digitDiscardInstructionName : null;
    }
    /**
     * Set digitDiscardInstructionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setDigitDiscardInstructionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $digitDiscardInstructionName = null)
    {
        if (is_null($digitDiscardInstructionName) || (is_array($digitDiscardInstructionName) && empty($digitDiscardInstructionName))) {
            unset($this->digitDiscardInstructionName);
        } else {
            $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        }
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * Set routeFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setRouteFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routeFilterName = null)
    {
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return string|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param string $callingPartyNumberingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setCallingPartyNumberingPlan($callingPartyNumberingPlan = 'Cisco CallManager')
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return string|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param string $callingPartyNumberType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setCallingPartyNumberType($callingPartyNumberType = 'Cisco CallManager')
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get mlppPreemptionDisabled value
     * @return string|null
     */
    public function getMlppPreemptionDisabled()
    {
        return $this->mlppPreemptionDisabled;
    }
    /**
     * Set mlppPreemptionDisabled value
     * @param string $mlppPreemptionDisabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallingPartyTransformationPattern
     */
    public function setMlppPreemptionDisabled($mlppPreemptionDisabled = 'false')
    {
        $this->mlppPreemptionDisabled = $mlppPreemptionDisabled;
        return $this;
    }
}
