<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallerFilterListMember StructType
 * @subpackage Structs
 */
class XCallerFilterListMember extends AbstractStructBase
{
    /**
     * The DnMask
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when "callerFilterMask" has value as Directory Number
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DnMask;
    /**
     * The callerFilterMask
     * Meta information extracted from the WSDL
     * - documentation: Mandatory when value is a directory number
     * - default: Directory Number
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callerFilterMask;
    /**
     * Constructor method for XCallerFilterListMember
     * @uses XCallerFilterListMember::setDnMask()
     * @uses XCallerFilterListMember::setCallerFilterMask()
     * @param string $dnMask
     * @param string $callerFilterMask
     */
    public function __construct($dnMask = null, $callerFilterMask = 'Directory Number')
    {
        $this
            ->setDnMask($dnMask)
            ->setCallerFilterMask($callerFilterMask);
    }
    /**
     * Get DnMask value
     * @return string
     */
    public function getDnMask()
    {
        return $this->DnMask;
    }
    /**
     * Set DnMask value
     * @param string $dnMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallerFilterListMember
     */
    public function setDnMask($dnMask = null)
    {
        $this->DnMask = $dnMask;
        return $this;
    }
    /**
     * Get callerFilterMask value
     * @return string
     */
    public function getCallerFilterMask()
    {
        return $this->callerFilterMask;
    }
    /**
     * Set callerFilterMask value
     * @param string $callerFilterMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCallerFilterListMember
     */
    public function setCallerFilterMask($callerFilterMask = 'Directory Number')
    {
        $this->callerFilterMask = $callerFilterMask;
        return $this;
    }
}
