<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userRoles StructType
 * @subpackage Structs
 */
class UserRoles extends XCommonMembersExtension
{
    /**
     * The userRole
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Name of the User role associated with the user group will be taken | READ ONLY: Name of the User Role associated with the user group will be taken.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XUserGroupRoles[]
     */
    public $userRole;
    /**
     * Constructor method for userRoles
     * @uses UserRoles::setUserRole()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XUserGroupRoles[] $userRole
     */
    public function __construct(array $userRole = array())
    {
        $this
            ->setUserRole($userRole);
    }
    /**
     * Get userRole value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XUserGroupRoles[]|null
     */
    public function getUserRole()
    {
        return $this->userRole;
    }
    /**
     * Set userRole value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XUserGroupRoles[] $userRole
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UserRoles
     */
    public function setUserRole(array $userRole = array())
    {
        $this->userRole = $userRole;
        return $this;
    }
    /**
     * Add item to userRole value
     * @throws \InvalidArgumentException
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XUserGroupRoles $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UserRoles
     */
    public function addToUserRole(\\Losc\CucmBundle\Model\Webservice\StructType\XUserGroupRoles $item)
    {
        $this->userRole[] = $item;
        return $this;
    }
}
