<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateWLANProfileReq StructType
 * @subpackage Structs
 */
class UpdateWLANProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The ssid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ssid;
    /**
     * The frequencyBand
     * Meta information extracted from the WSDL
     * - default: Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $frequencyBand;
    /**
     * The userModifiable
     * Meta information extracted from the WSDL
     * - default: Disallowed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userModifiable;
    /**
     * The authMethod
     * Meta information extracted from the WSDL
     * - default: EAP-FAST
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authMethod;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pskPassphrase
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pskPassphrase;
    /**
     * The wepKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $wepKey;
    /**
     * The passwordDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $passwordDescription;
    /**
     * The networkAccessProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $networkAccessProfile;
    /**
     * Constructor method for UpdateWLANProfileReq
     * @uses UpdateWLANProfileReq::setNewName()
     * @uses UpdateWLANProfileReq::setDescription()
     * @uses UpdateWLANProfileReq::setSsid()
     * @uses UpdateWLANProfileReq::setFrequencyBand()
     * @uses UpdateWLANProfileReq::setUserModifiable()
     * @uses UpdateWLANProfileReq::setAuthMethod()
     * @uses UpdateWLANProfileReq::setUserName()
     * @uses UpdateWLANProfileReq::setPassword()
     * @uses UpdateWLANProfileReq::setPskPassphrase()
     * @uses UpdateWLANProfileReq::setWepKey()
     * @uses UpdateWLANProfileReq::setPasswordDescription()
     * @uses UpdateWLANProfileReq::setNetworkAccessProfile()
     * @param string $newName
     * @param string $description
     * @param string $ssid
     * @param string $frequencyBand
     * @param string $userModifiable
     * @param string $authMethod
     * @param string $userName
     * @param string $password
     * @param string $pskPassphrase
     * @param string $wepKey
     * @param string $passwordDescription
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile
     */
    public function __construct($newName = null, $description = null, $ssid = null, $frequencyBand = 'Auto', $userModifiable = 'Disallowed', $authMethod = 'EAP-FAST', $userName = null, $password = null, $pskPassphrase = null, $wepKey = null, $passwordDescription = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSsid($ssid)
            ->setFrequencyBand($frequencyBand)
            ->setUserModifiable($userModifiable)
            ->setAuthMethod($authMethod)
            ->setUserName($userName)
            ->setPassword($password)
            ->setPskPassphrase($pskPassphrase)
            ->setWepKey($wepKey)
            ->setPasswordDescription($passwordDescription)
            ->setNetworkAccessProfile($networkAccessProfile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssid value
     * @return string|null
     */
    public function getSsid()
    {
        return $this->ssid;
    }
    /**
     * Set ssid value
     * @param string $ssid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setSsid($ssid = null)
    {
        $this->ssid = $ssid;
        return $this;
    }
    /**
     * Get frequencyBand value
     * @return string|null
     */
    public function getFrequencyBand()
    {
        return $this->frequencyBand;
    }
    /**
     * Set frequencyBand value
     * @param string $frequencyBand
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setFrequencyBand($frequencyBand = 'Auto')
    {
        $this->frequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get userModifiable value
     * @return string|null
     */
    public function getUserModifiable()
    {
        return $this->userModifiable;
    }
    /**
     * Set userModifiable value
     * @param string $userModifiable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setUserModifiable($userModifiable = 'Disallowed')
    {
        $this->userModifiable = $userModifiable;
        return $this;
    }
    /**
     * Get authMethod value
     * @return string|null
     */
    public function getAuthMethod()
    {
        return $this->authMethod;
    }
    /**
     * Set authMethod value
     * @param string $authMethod
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setAuthMethod($authMethod = 'EAP-FAST')
    {
        $this->authMethod = $authMethod;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setUserName($userName = null)
    {
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get pskPassphrase value
     * @return string|null
     */
    public function getPskPassphrase()
    {
        return $this->pskPassphrase;
    }
    /**
     * Set pskPassphrase value
     * @param string $pskPassphrase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setPskPassphrase($pskPassphrase = null)
    {
        $this->pskPassphrase = $pskPassphrase;
        return $this;
    }
    /**
     * Get wepKey value
     * @return string|null
     */
    public function getWepKey()
    {
        return $this->wepKey;
    }
    /**
     * Set wepKey value
     * @param string $wepKey
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setWepKey($wepKey = null)
    {
        $this->wepKey = $wepKey;
        return $this;
    }
    /**
     * Get passwordDescription value
     * @return string|null
     */
    public function getPasswordDescription()
    {
        return $this->passwordDescription;
    }
    /**
     * Set passwordDescription value
     * @param string $passwordDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setPasswordDescription($passwordDescription = null)
    {
        $this->passwordDescription = $passwordDescription;
        return $this;
    }
    /**
     * Get networkAccessProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNetworkAccessProfile()
    {
        return isset($this->networkAccessProfile) ? $this->networkAccessProfile : null;
    }
    /**
     * Set networkAccessProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateWLANProfileReq
     */
    public function setNetworkAccessProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $networkAccessProfile = null)
    {
        if (is_null($networkAccessProfile) || (is_array($networkAccessProfile) && empty($networkAccessProfile))) {
            unset($this->networkAccessProfile);
        } else {
            $this->networkAccessProfile = $networkAccessProfile;
        }
        return $this;
    }
}
