<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoiceMailProfileReq StructType
 * @subpackage Structs
 */
class UpdateVoiceMailProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailProfile as Default. Instead, the corresponding tag of another VoiceMailProfile should be set to true.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The voiceMailboxMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voiceMailboxMask;
    /**
     * The voiceMailPilot
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVmPilot
     */
    public $voiceMailPilot;
    /**
     * Constructor method for UpdateVoiceMailProfileReq
     * @uses UpdateVoiceMailProfileReq::setNewName()
     * @uses UpdateVoiceMailProfileReq::setDescription()
     * @uses UpdateVoiceMailProfileReq::setIsDefault()
     * @uses UpdateVoiceMailProfileReq::setVoiceMailboxMask()
     * @uses UpdateVoiceMailProfileReq::setVoiceMailPilot()
     * @param string $newName
     * @param string $description
     * @param string $isDefault
     * @param string $voiceMailboxMask
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVmPilot $voiceMailPilot
     */
    public function __construct($newName = null, $description = null, $isDefault = 'false', $voiceMailboxMask = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVmPilot $voiceMailPilot = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setVoiceMailboxMask($voiceMailboxMask)
            ->setVoiceMailPilot($voiceMailPilot);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq
     */
    public function setIsDefault($isDefault = 'false')
    {
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get voiceMailboxMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoiceMailboxMask()
    {
        return isset($this->voiceMailboxMask) ? $this->voiceMailboxMask : null;
    }
    /**
     * Set voiceMailboxMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voiceMailboxMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq
     */
    public function setVoiceMailboxMask($voiceMailboxMask = null)
    {
        if (is_null($voiceMailboxMask) || (is_array($voiceMailboxMask) && empty($voiceMailboxMask))) {
            unset($this->voiceMailboxMask);
        } else {
            $this->voiceMailboxMask = $voiceMailboxMask;
        }
        return $this;
    }
    /**
     * Get voiceMailPilot value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVmPilot|null
     */
    public function getVoiceMailPilot()
    {
        return $this->voiceMailPilot;
    }
    /**
     * Set voiceMailPilot value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVmPilot $voiceMailPilot
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateVoiceMailProfileReq
     */
    public function setVoiceMailPilot(\\Losc\CucmBundle\Model\Webservice\StructType\XVmPilot $voiceMailPilot = null)
    {
        $this->voiceMailPilot = $voiceMailPilot;
        return $this;
    }
}
