<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipRoutePatternReq StructType
 * @subpackage Structs
 */
class UpdateSipRoutePatternReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern | routePartitionName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The blockEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockEnable;
    /**
     * The callingPartyTransformationMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyTransformationMask;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useCallingPartyPhoneMask;
    /**
     * The callingPartyPrefixDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyPrefixDigits;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentationBit;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The dnOrPatternIpv6
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dnOrPatternIpv6;
    /**
     * The routeOnUserPart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeOnUserPart;
    /**
     * The useCallerCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerCss;
    /**
     * The domainRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $domainRoutingCssName;
    /**
     * Constructor method for UpdateSipRoutePatternReq
     * @uses UpdateSipRoutePatternReq::setPattern()
     * @uses UpdateSipRoutePatternReq::setRoutePartitionName()
     * @uses UpdateSipRoutePatternReq::setUuid()
     * @uses UpdateSipRoutePatternReq::setNewPattern()
     * @uses UpdateSipRoutePatternReq::setDescription()
     * @uses UpdateSipRoutePatternReq::setNewRoutePartitionName()
     * @uses UpdateSipRoutePatternReq::setBlockEnable()
     * @uses UpdateSipRoutePatternReq::setCallingPartyTransformationMask()
     * @uses UpdateSipRoutePatternReq::setUseCallingPartyPhoneMask()
     * @uses UpdateSipRoutePatternReq::setCallingPartyPrefixDigits()
     * @uses UpdateSipRoutePatternReq::setCallingLinePresentationBit()
     * @uses UpdateSipRoutePatternReq::setCallingNamePresentationBit()
     * @uses UpdateSipRoutePatternReq::setConnectedLinePresentationBit()
     * @uses UpdateSipRoutePatternReq::setConnectedNamePresentationBit()
     * @uses UpdateSipRoutePatternReq::setSipTrunkName()
     * @uses UpdateSipRoutePatternReq::setDnOrPatternIpv6()
     * @uses UpdateSipRoutePatternReq::setRouteOnUserPart()
     * @uses UpdateSipRoutePatternReq::setUseCallerCss()
     * @uses UpdateSipRoutePatternReq::setDomainRoutingCssName()
     * @param string $pattern
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @param string $uuid
     * @param string $newPattern
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName
     * @param string $blockEnable
     * @param string $callingPartyTransformationMask
     * @param string $useCallingPartyPhoneMask
     * @param string $callingPartyPrefixDigits
     * @param string $callingLinePresentationBit
     * @param string $callingNamePresentationBit
     * @param string $connectedLinePresentationBit
     * @param string $connectedNamePresentationBit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param string $dnOrPatternIpv6
     * @param string $routeOnUserPart
     * @param string $useCallerCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName
     */
    public function __construct($pattern = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null, $uuid = null, $newPattern = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName = null, $blockEnable = null, $callingPartyTransformationMask = null, $useCallingPartyPhoneMask = 'Default', $callingPartyPrefixDigits = null, $callingLinePresentationBit = 'Default', $callingNamePresentationBit = 'Default', $connectedLinePresentationBit = 'Default', $connectedNamePresentationBit = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, $dnOrPatternIpv6 = null, $routeOnUserPart = null, $useCallerCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setBlockEnable($blockEnable)
            ->setCallingPartyTransformationMask($callingPartyTransformationMask)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setCallingPartyPrefixDigits($callingPartyPrefixDigits)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setSipTrunkName($sipTrunkName)
            ->setDnOrPatternIpv6($dnOrPatternIpv6)
            ->setRouteOnUserPart($routeOnUserPart)
            ->setUseCallerCss($useCallerCss)
            ->setDomainRoutingCssName($domainRoutingCssName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setNewPattern($newPattern = null)
    {
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setNewRoutePartitionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get blockEnable value
     * @return string|null
     */
    public function getBlockEnable()
    {
        return $this->blockEnable;
    }
    /**
     * Set blockEnable value
     * @param string $blockEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setBlockEnable($blockEnable = null)
    {
        $this->blockEnable = $blockEnable;
        return $this;
    }
    /**
     * Get callingPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyTransformationMask()
    {
        return isset($this->callingPartyTransformationMask) ? $this->callingPartyTransformationMask : null;
    }
    /**
     * Set callingPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyTransformationMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setCallingPartyTransformationMask($callingPartyTransformationMask = null)
    {
        if (is_null($callingPartyTransformationMask) || (is_array($callingPartyTransformationMask) && empty($callingPartyTransformationMask))) {
            unset($this->callingPartyTransformationMask);
        } else {
            $this->callingPartyTransformationMask = $callingPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return string|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param string $useCallingPartyPhoneMask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setUseCallingPartyPhoneMask($useCallingPartyPhoneMask = 'Default')
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get callingPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyPrefixDigits()
    {
        return isset($this->callingPartyPrefixDigits) ? $this->callingPartyPrefixDigits : null;
    }
    /**
     * Set callingPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callingPartyPrefixDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setCallingPartyPrefixDigits($callingPartyPrefixDigits = null)
    {
        if (is_null($callingPartyPrefixDigits) || (is_array($callingPartyPrefixDigits) && empty($callingPartyPrefixDigits))) {
            unset($this->callingPartyPrefixDigits);
        } else {
            $this->callingPartyPrefixDigits = $callingPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return string|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param string $callingNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setCallingNamePresentationBit($callingNamePresentationBit = 'Default')
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return string|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param string $connectedLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setConnectedLinePresentationBit($connectedLinePresentationBit = 'Default')
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return string|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param string $connectedNamePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setConnectedNamePresentationBit($connectedNamePresentationBit = 'Default')
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setSipTrunkName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get dnOrPatternIpv6 value
     * @return string|null
     */
    public function getDnOrPatternIpv6()
    {
        return $this->dnOrPatternIpv6;
    }
    /**
     * Set dnOrPatternIpv6 value
     * @param string $dnOrPatternIpv6
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setDnOrPatternIpv6($dnOrPatternIpv6 = null)
    {
        $this->dnOrPatternIpv6 = $dnOrPatternIpv6;
        return $this;
    }
    /**
     * Get routeOnUserPart value
     * @return string|null
     */
    public function getRouteOnUserPart()
    {
        return $this->routeOnUserPart;
    }
    /**
     * Set routeOnUserPart value
     * @param string $routeOnUserPart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setRouteOnUserPart($routeOnUserPart = null)
    {
        $this->routeOnUserPart = $routeOnUserPart;
        return $this;
    }
    /**
     * Get useCallerCss value
     * @return string|null
     */
    public function getUseCallerCss()
    {
        return $this->useCallerCss;
    }
    /**
     * Set useCallerCss value
     * @param string $useCallerCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setUseCallerCss($useCallerCss = null)
    {
        $this->useCallerCss = $useCallerCss;
        return $this;
    }
    /**
     * Get domainRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDomainRoutingCssName()
    {
        return isset($this->domainRoutingCssName) ? $this->domainRoutingCssName : null;
    }
    /**
     * Set domainRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRoutePatternReq
     */
    public function setDomainRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $domainRoutingCssName = null)
    {
        if (is_null($domainRoutingCssName) || (is_array($domainRoutingCssName) && empty($domainRoutingCssName))) {
            unset($this->domainRoutingCssName);
        } else {
            $this->domainRoutingCssName = $domainRoutingCssName;
        }
        return $this;
    }
}
