<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipRealmReq StructType
 * @subpackage Structs
 */
class UpdateSipRealmReq extends APIRequest
{
    /**
     * The realm
     * Meta information extracted from the WSDL
     * - choice: uuid | realm
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $realm;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | realm
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newRealm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newRealm;
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $digestCredentials;
    /**
     * Constructor method for UpdateSipRealmReq
     * @uses UpdateSipRealmReq::setRealm()
     * @uses UpdateSipRealmReq::setUuid()
     * @uses UpdateSipRealmReq::setNewRealm()
     * @uses UpdateSipRealmReq::setUserid()
     * @uses UpdateSipRealmReq::setDigestCredentials()
     * @param string $realm
     * @param string $uuid
     * @param string $newRealm
     * @param string $userid
     * @param string $digestCredentials
     */
    public function __construct($realm = null, $uuid = null, $newRealm = null, $userid = null, $digestCredentials = null)
    {
        $this
            ->setRealm($realm)
            ->setUuid($uuid)
            ->setNewRealm($newRealm)
            ->setUserid($userid)
            ->setDigestCredentials($digestCredentials);
    }
    /**
     * Get realm value
     * @return string
     */
    public function getRealm()
    {
        return isset($this->realm) ? $this->realm : null;
    }
    /**
     * Set realm value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $realm
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq
     */
    public function setRealm($realm = null)
    {
        if (is_null($realm) || (is_array($realm) && empty($realm))) {
            unset($this->realm);
        } else {
            $this->realm = $realm;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newRealm value
     * @return string|null
     */
    public function getNewRealm()
    {
        return $this->newRealm;
    }
    /**
     * Set newRealm value
     * @param string $newRealm
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq
     */
    public function setNewRealm($newRealm = null)
    {
        $this->newRealm = $newRealm;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq
     */
    public function setUserid($userid = null)
    {
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSipRealmReq
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
}
