<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneSecurityProfileReq StructType
 * @subpackage Structs
 */
class UpdatePhoneSecurityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * Constructor method for UpdatePhoneSecurityProfileReq
     * @uses UpdatePhoneSecurityProfileReq::setNewName()
     * @uses UpdatePhoneSecurityProfileReq::setDescription()
     * @uses UpdatePhoneSecurityProfileReq::setDeviceSecurityMode()
     * @uses UpdatePhoneSecurityProfileReq::setAuthenticationMode()
     * @uses UpdatePhoneSecurityProfileReq::setKeySize()
     * @uses UpdatePhoneSecurityProfileReq::setTftpEncryptedConfig()
     * @uses UpdatePhoneSecurityProfileReq::setNonceValidityTime()
     * @uses UpdatePhoneSecurityProfileReq::setTransportType()
     * @uses UpdatePhoneSecurityProfileReq::setSipPhonePort()
     * @uses UpdatePhoneSecurityProfileReq::setEnableDigestAuthentication()
     * @uses UpdatePhoneSecurityProfileReq::setExcludeDigestCredentials()
     * @param string $newName
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     */
    public function __construct($newName = null, $description = null, $deviceSecurityMode = null, $authenticationMode = 'By Null String', $keySize = '1024', $tftpEncryptedConfig = 'false', $nonceValidityTime = '600', $transportType = 'TCP+UDP', $sipPhonePort = '5060', $enableDigestAuthentication = 'false', $excludeDigestCredentials = 'false')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return isset($this->deviceSecurityMode) ? $this->deviceSecurityMode : null;
    }
    /**
     * Set deviceSecurityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceSecurityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        if (is_null($deviceSecurityMode) || (is_array($deviceSecurityMode) && empty($deviceSecurityMode))) {
            unset($this->deviceSecurityMode);
        } else {
            $this->deviceSecurityMode = $deviceSecurityMode;
        }
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param string $authenticationMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param string $keySize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setKeySize($keySize = '1024')
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = 'false')
    {
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @param string $nonceValidityTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setNonceValidityTime($nonceValidityTime = '600')
    {
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @param string $transportType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @param string $sipPhonePort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setSipPhonePort($sipPhonePort = '5060')
    {
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = 'false')
    {
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneSecurityProfileReq
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = 'false')
    {
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
}
