<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateNetworkAccessProfileReq StructType
 * @subpackage Structs
 */
class UpdateNetworkAccessProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The vpnRequired
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $vpnRequired;
    /**
     * The proxySettings
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxySettings;
    /**
     * The proxyHostname
     * Meta information extracted from the WSDL
     * - documentation: This tag corresponds to Proxy Auto-Config (PAC) Location when proxy setting is set to Auto
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyHostname;
    /**
     * The proxyPort
     * Meta information extracted from the WSDL
     * - default: 8080
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyPort;
    /**
     * The proxyRequiresAuthentication
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $proxyRequiresAuthentication;
    /**
     * The provideSharedCredentials
     * Meta information extracted from the WSDL
     * - documentation: This tag is used for validation and does not correspond to any field in database.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $provideSharedCredentials;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * Constructor method for UpdateNetworkAccessProfileReq
     * @uses UpdateNetworkAccessProfileReq::setNewName()
     * @uses UpdateNetworkAccessProfileReq::setDescription()
     * @uses UpdateNetworkAccessProfileReq::setVpnRequired()
     * @uses UpdateNetworkAccessProfileReq::setProxySettings()
     * @uses UpdateNetworkAccessProfileReq::setProxyHostname()
     * @uses UpdateNetworkAccessProfileReq::setProxyPort()
     * @uses UpdateNetworkAccessProfileReq::setProxyRequiresAuthentication()
     * @uses UpdateNetworkAccessProfileReq::setProvideSharedCredentials()
     * @uses UpdateNetworkAccessProfileReq::setUsername()
     * @uses UpdateNetworkAccessProfileReq::setPassword()
     * @param string $newName
     * @param string $description
     * @param string $vpnRequired
     * @param string $proxySettings
     * @param string $proxyHostname
     * @param string $proxyPort
     * @param string $proxyRequiresAuthentication
     * @param string $provideSharedCredentials
     * @param string $username
     * @param string $password
     */
    public function __construct($newName = null, $description = null, $vpnRequired = 'Default', $proxySettings = 'None', $proxyHostname = null, $proxyPort = '8080', $proxyRequiresAuthentication = 'false', $provideSharedCredentials = 'false', $username = null, $password = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setVpnRequired($vpnRequired)
            ->setProxySettings($proxySettings)
            ->setProxyHostname($proxyHostname)
            ->setProxyPort($proxyPort)
            ->setProxyRequiresAuthentication($proxyRequiresAuthentication)
            ->setProvideSharedCredentials($provideSharedCredentials)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get vpnRequired value
     * @return string|null
     */
    public function getVpnRequired()
    {
        return $this->vpnRequired;
    }
    /**
     * Set vpnRequired value
     * @param string $vpnRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setVpnRequired($vpnRequired = 'Default')
    {
        $this->vpnRequired = $vpnRequired;
        return $this;
    }
    /**
     * Get proxySettings value
     * @return string|null
     */
    public function getProxySettings()
    {
        return $this->proxySettings;
    }
    /**
     * Set proxySettings value
     * @param string $proxySettings
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxySettings($proxySettings = 'None')
    {
        $this->proxySettings = $proxySettings;
        return $this;
    }
    /**
     * Get proxyHostname value
     * @return string|null
     */
    public function getProxyHostname()
    {
        return $this->proxyHostname;
    }
    /**
     * Set proxyHostname value
     * @param string $proxyHostname
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyHostname($proxyHostname = null)
    {
        $this->proxyHostname = $proxyHostname;
        return $this;
    }
    /**
     * Get proxyPort value
     * @return string|null
     */
    public function getProxyPort()
    {
        return $this->proxyPort;
    }
    /**
     * Set proxyPort value
     * @param string $proxyPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyPort($proxyPort = '8080')
    {
        $this->proxyPort = $proxyPort;
        return $this;
    }
    /**
     * Get proxyRequiresAuthentication value
     * @return string|null
     */
    public function getProxyRequiresAuthentication()
    {
        return $this->proxyRequiresAuthentication;
    }
    /**
     * Set proxyRequiresAuthentication value
     * @param string $proxyRequiresAuthentication
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProxyRequiresAuthentication($proxyRequiresAuthentication = 'false')
    {
        $this->proxyRequiresAuthentication = $proxyRequiresAuthentication;
        return $this;
    }
    /**
     * Get provideSharedCredentials value
     * @return string|null
     */
    public function getProvideSharedCredentials()
    {
        return $this->provideSharedCredentials;
    }
    /**
     * Set provideSharedCredentials value
     * @param string $provideSharedCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setProvideSharedCredentials($provideSharedCredentials = 'false')
    {
        $this->provideSharedCredentials = $provideSharedCredentials;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setUsername($username = null)
    {
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateNetworkAccessProfileReq
     */
    public function setPassword($password = null)
    {
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
}
