<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMtpReq StructType
 * @subpackage Structs
 */
class UpdateMtpReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The trustedRelayPoint
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trustedRelayPoint;
    /**
     * Constructor method for UpdateMtpReq
     * @uses UpdateMtpReq::setNewName()
     * @uses UpdateMtpReq::setDescription()
     * @uses UpdateMtpReq::setDevicePoolName()
     * @uses UpdateMtpReq::setTrustedRelayPoint()
     * @param string $newName
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param string $trustedRelayPoint
     */
    public function __construct($newName = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, $trustedRelayPoint = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDevicePoolName($devicePoolName)
            ->setTrustedRelayPoint($trustedRelayPoint);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMtpReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMtpReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMtpReq
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get trustedRelayPoint value
     * @return string|null
     */
    public function getTrustedRelayPoint()
    {
        return $this->trustedRelayPoint;
    }
    /**
     * Set trustedRelayPoint value
     * @param string $trustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMtpReq
     */
    public function setTrustedRelayPoint($trustedRelayPoint = null)
    {
        $this->trustedRelayPoint = $trustedRelayPoint;
        return $this;
    }
}
