<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMohAudioSourceReq StructType
 * @subpackage Structs
 */
class UpdateMohAudioSourceReq extends APIRequest
{
    /**
     * The sourceId
     * Meta information extracted from the WSDL
     * - choice: uuid | sourceId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $sourceId;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | sourceId
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The sourceFile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sourceFile;
    /**
     * The multicast
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The mohFileStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mohFileStatus;
    /**
     * The initialAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $periodicAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta information extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta information extracted from the WSDL
     * - default: English United States
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * Constructor method for UpdateMohAudioSourceReq
     * @uses UpdateMohAudioSourceReq::setSourceId()
     * @uses UpdateMohAudioSourceReq::setUuid()
     * @uses UpdateMohAudioSourceReq::setNewName()
     * @uses UpdateMohAudioSourceReq::setSourceFile()
     * @uses UpdateMohAudioSourceReq::setMulticast()
     * @uses UpdateMohAudioSourceReq::setMohFileStatus()
     * @uses UpdateMohAudioSourceReq::setInitialAnnouncement()
     * @uses UpdateMohAudioSourceReq::setPeriodicAnnouncement()
     * @uses UpdateMohAudioSourceReq::setPeriodicAnnouncementInterval()
     * @uses UpdateMohAudioSourceReq::setLocaleAnnouncement()
     * @uses UpdateMohAudioSourceReq::setInitialAnnouncementPlayed()
     * @param string $sourceId
     * @param string $uuid
     * @param string $newName
     * @param string $sourceFile
     * @param string $multicast
     * @param string $mohFileStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $initialAnnouncementPlayed
     */
    public function __construct($sourceId = null, $uuid = null, $newName = null, $sourceFile = null, $multicast = null, $mohFileStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null, $periodicAnnouncementInterval = '30', $localeAnnouncement = 'English United States', $initialAnnouncementPlayed = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setSourceFile($sourceFile)
            ->setMulticast($multicast)
            ->setMohFileStatus($mohFileStatus)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed);
    }
    /**
     * Get sourceId value
     * @return string
     */
    public function getSourceId()
    {
        return isset($this->sourceId) ? $this->sourceId : null;
    }
    /**
     * Set sourceId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $sourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setSourceId($sourceId = null)
    {
        if (is_null($sourceId) || (is_array($sourceId) && empty($sourceId))) {
            unset($this->sourceId);
        } else {
            $this->sourceId = $sourceId;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get sourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->sourceFile;
    }
    /**
     * Set sourceFile value
     * @param string $sourceFile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setSourceFile($sourceFile = null)
    {
        $this->sourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setMulticast($multicast = null)
    {
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get mohFileStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMohFileStatus()
    {
        return isset($this->mohFileStatus) ? $this->mohFileStatus : null;
    }
    /**
     * Set mohFileStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mohFileStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setMohFileStatus($mohFileStatus = null)
    {
        if (is_null($mohFileStatus) || (is_array($mohFileStatus) && empty($mohFileStatus))) {
            unset($this->mohFileStatus);
        } else {
            $this->mohFileStatus = $mohFileStatus;
        }
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInitialAnnouncement()
    {
        return isset($this->initialAnnouncement) ? $this->initialAnnouncement : null;
    }
    /**
     * Set initialAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setInitialAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $initialAnnouncement = null)
    {
        if (is_null($initialAnnouncement) || (is_array($initialAnnouncement) && empty($initialAnnouncement))) {
            unset($this->initialAnnouncement);
        } else {
            $this->initialAnnouncement = $initialAnnouncement;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return isset($this->periodicAnnouncement) ? $this->periodicAnnouncement : null;
    }
    /**
     * Set periodicAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setPeriodicAnnouncement(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $periodicAnnouncement = null)
    {
        if (is_null($periodicAnnouncement) || (is_array($periodicAnnouncement) && empty($periodicAnnouncement))) {
            unset($this->periodicAnnouncement);
        } else {
            $this->periodicAnnouncement = $periodicAnnouncement;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string|null
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @param string $periodicAnnouncementInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = '30')
    {
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string|null
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @param string $localeAnnouncement
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setLocaleAnnouncement($localeAnnouncement = 'English United States')
    {
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateMohAudioSourceReq
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
}
